(in-package #:cl-fast-behavior-trees)


(define-let+-expansion (&helper (name lambda-list &body function-body)
                        :uses-value? nil)
  `(flet ((,name ,lambda-list ,@function-body))
     (declare (ignorable (function ,name))
              (inline ,name))
     ,@let-plus::body))

(defstruct behavior-tree-node
  (name :|| :type symbol)
  (slot-names nil :type list)
  (slot-defaults nil :type list)
  (slot-types nil :type list)
  (slot-docstrings nil :type list)
  (function nil :type symbol)
  (inline nil :type boolean)
  (options-components-ro nil :type list)
  (options-components-rw nil :type list)
  (options-components-no nil :type list)
  (options-arguments nil :type list)
  (options-initially nil :type list)
  (options-finally nil :type list)
  options-when
  options-enable
  (options-after nil :type list)
  (options-before nil :type list))

(declaim (type hash-table *node-types*))
(defvar *node-types* (make-hash-table :test #'eq))

(defmacro define-behavior-tree-node (name-and-options (&rest slots) &body body)
  (let+ ((name (if (typep name-and-options 'symbol)
                   name-and-options (first name-and-options)))
         (options (if (typep name-and-options 'symbol)
                      nil (rest name-and-options)))
         (components-ro (getf options :components-ro))
         (components-rw (getf options :components-rw))
         (components-no (getf options :components-no))
         (arguments (getf options :arguments))
         (inline (getf options :inline))
         (slot-names (mapcar #'first slots))
         (slot-defaults (mapcar #'second slots))
         (slot-types (mapcar (lambda (s) (getf s :type t)) slots))
         (slot-docstrings (mapcar (lambda (s) (getf s :documentation "")) slots))
         (slot-accessor-names (mapcar (compose #'gensym #'string) slot-names))
         (node-function (intern (string (gensym (string name)))))
         (entity (intern "ENTITY" *package*))
         ((&values forms declarations docstring)
          (parse-body body :documentation t))
         ((&with-gensyms component-storages
                         child-completed-fn child-succeeded-fn
                         complete-fn deactivate-fn activate-child-fn
                         reset-children-fn reset-tree-fn return-from-tree-fn
                         delete-tree-fn)))
    `(eval-when (:compile-toplevel :load-toplevel :execute)
       (declaim ,@(unless (find-package :trivial-coverage)
                    ;; NOTE: inlining messes up test coverage counting
                    `((inline ,node-function)))
                (ftype (function ((simple-array
                                   (or ecs::component-soa null) (*))
                                  ecs:entity
                                  boolean
                                  array-length
                                  (function (array-index) boolean)
                                  (function (array-index) boolean)
                                  (function (boolean))
                                  (function ())
                                  (function (array-index))
                                  (function ())
                                  (function ())
                                  (function ())
                                  (function ())
                                  ,@(mapcar
                                     (lambda (type)
                                       `(function (&optional ,type) ,type))
                                     slot-types)
                                  &key
                                  ,@(mapcar
                                     (lambda (arg)
                                       (list (make-keyword (first arg))
                                             (second arg)))
                                     arguments)))
                       ,node-function))
       (defun ,node-function (,component-storages
                              ,entity rootp children-count
                              ,child-completed-fn ,child-succeeded-fn
                              ,complete-fn ,deactivate-fn ,activate-child-fn
                              ,reset-children-fn ,reset-tree-fn
                              ,return-from-tree-fn ,delete-tree-fn
                              ,@slot-accessor-names
                              &key ,@(mapcar #'first arguments))
         ,@declarations
         (declare (ignorable ,component-storages ,entity rootp children-count))
         ,@(when docstring (list docstring))
         (let+ (((&helper complete-node (success)
                   (funcall ,complete-fn success)))
                ((&helper child-completed-p (i)
                   (funcall ,child-completed-fn i)))
                ((&helper child-succeeded-p (i)
                   (funcall ,child-succeeded-fn i)))
                ((&helper deactivate ()
                   (funcall ,deactivate-fn)))
                ((&helper activate-child (i)
                   (funcall ,activate-child-fn i)))
                ((&helper reset-children ()
                   (funcall ,reset-children-fn)))
                ((&helper reset-tree ()
                   (funcall ,reset-tree-fn)))
                ((&helper return-from-tree ()
                   (funcall ,return-from-tree-fn)))
                ((&helper delete-tree ()
                   (funcall ,delete-tree-fn)))
                ,@(mapcan
                   (lambda (name accessor)
                     (let ((accessor-helper (gensym (string name))))
                       `(((&helper ,accessor-helper ()
                            (funcall ,accessor)))
                         ((&helper (setf ,accessor-helper) (value)
                            (funcall ,accessor value)))
                         ((&symbol-macrolet ,name (,accessor-helper))))))
                   slot-names slot-accessor-names))
           (block nil
             (block ,name
                 ,@(reduce
                    (lambda (bindings name)
                      `((,(ecs::format-symbol/component
                           name "%WITH-~a-SLOTS" name)
                         nil ,(find name components-ro :test #'eq)
                         ,component-storages ,entity ,@bindings)))
                    (append components-ro components-rw)
                    :initial-value forms))))
         (values))
       (setf (gethash ',name *node-types*)
             (make-behavior-tree-node
              :name ',name
              :slot-names ',slot-names
              :slot-defaults ',slot-defaults
              :slot-types ',slot-types
              :slot-docstrings ',slot-docstrings
              :function ',node-function
              :inline ,inline
              :options-components-ro ',components-ro
              :options-components-rw ',components-rw
              :options-components-no ',components-no
              :options-arguments ',arguments
              :options-initially ',(getf options :initially)
              :options-finally ',(getf options :finally)
              :options-when ',(getf options :when t)
              :options-enable ',(getf options :enable t)
              :options-after ',(getf options :after)
              :options-before ',(getf options :before)))
       ',name)))
