(in-package #:cl-fast-behavior-trees/tests)


(define-test cl-fast-behavior-trees)

(defparameter *enable-colors* NIL)

(defun run ()
  (clear-coverage)
  (let* ((interactivep (or (find :slynk *features*)
                           (find :swank *features*)))
         (*enable-colors* (not interactivep))
         (report (test (if uiop:*command-line-arguments*
                           (mapcar (lambda (a)
                                     (alexandria:format-symbol
                                      'cl-fast-behavior-trees/tests
                                      "~:@(~a~)" a))
                                   uiop:*command-line-arguments*)
                           'cl-fast-behavior-trees)
                       :report
                       (if interactivep 'interactive 'plain))))
    #+sbcl (when (uiop:getenvp "COVERAGE")
             (handler-bind ((warning #'muffle-warning))
               (create-coverage-report "coverage/")
               (pprint-coverage
                (get-coverage "coverage/"
                              :exclude '("main.lisp"
                                         "package.lisp"
                                         "test-nodes.lisp"
                                         "test-standard-nodes.lisp"
                                         "test-trees.lisp")))))
    (unless interactivep
      (uiop:quit (if (eq :failed (status report)) 1 0) NIL))
    report))

(defparameter *regular* 39)
(defparameter *green* 32)
(defparameter *red* 31)

(defun color-text (color text)
  (if *enable-colors*
      (format nil "[0;~am~a[0;39m" color text)
      text))

(defun status-text (result text)
  (color-text
   (case (status result)
     (:passed *green*)
     (:failed *red*)
     (otherwise *regular*))
   text))

(defmethod parachute:format-result :around ((result result)
                                            (type (eql :oneline)))
  (status-text result (call-next-method)))

(defmethod parachute:format-result :around ((result test-result)
                                            (type (eql :oneline)))
  (let ((*print-case* :downcase)
        (name (name (expression result))))
    (status-text result (format NIL "~a" name))))
