(in-package #:cl-fast-behavior-trees/tests)


(define-test dump
  :parent cl-fast-behavior-trees)

(define-test dump-smoke-test
  :parent dump
  (eval
   '(define-behavior-tree test75
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test75-behavior-tree entity)
    (true (plusp (length (dump-behavior-tree entity))))))

(define-test dump-with-no-marker
  :parent dump
  (eval
   '(define-behavior-tree test76
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-object `((:test76)))))
    (fail (dump-behavior-tree entity))))

(define-test dump-to-file
  :parent dump
  (eval
   '(define-behavior-tree test77
     ((:repeat)
      ((:always-true)))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test77-behavior-tree entity)
    (uiop:with-temporary-file (:pathname file :type "dot")
      (dump-behavior-tree/file entity file)
      (let ((contents (alexandria:read-file-into-string file)))
        (true (search (format nil "digraph behavior_tree_~a {" entity) contents))
        (true (search "\"REPEAT1\"[shape=oval,label=\"REPEAT1\",style=\"filled\"];" contents))
        (true (search "\"ALWAYS-TRUE1\"[shape=rect,label=\"ALWAYS-TRUE1\",style=\"\"];" contents))
        (is char= #\} (alexandria:last-elt contents))))))

(define-test dump-to-picture
  :parent dump
  (eval
   '(define-behavior-tree test78
     ((:repeat)
      ((:always-true)))))
  (ecs:make-storage)
  (uiop:with-temporary-file (:pathname picture :type "png")
    (let* ((entity (ecs:make-entity))
           (_ (make-test78-behavior-tree entity))
           (source (dump-behavior-tree/picture entity picture :keep-source t))
           (contents (alexandria:read-file-into-string source)))
      (declare (ignore _))
      (true (probe-file picture))
      (true (search (format nil "digraph behavior_tree_~a {" entity) contents))
      (true (search "\"REPEAT1\"[shape=oval,label=\"REPEAT1\",style=\"filled\"];" contents))
      (true (search "\"ALWAYS-TRUE1\"[shape=rect,label=\"ALWAYS-TRUE1\",style=\"\"];" contents))
      (is char= #\} (alexandria:last-elt contents)))))

(define-test dump-to-picture-unknown-format
  :parent dump
  (eval
   '(define-behavior-tree test78
     ((:repeat)
      ((:always-true)))))
  (ecs:make-storage)
  (uiop:with-temporary-file (:pathname picture :type "png")
    (let ((entity (ecs:make-entity)))
      (make-test78-behavior-tree entity)
      (fail
       (dump-behavior-tree/picture entity picture :format :rawr)))))

(define-test dump-node-names
  :parent dump
  (eval
   '(define-behavior-tree test79
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity))
         (_ (make-test79-behavior-tree entity))
         (contents (dump-behavior-tree entity)))
    (declare (ignore _))
    (true (search (format nil "ROOT~%REPEAT") contents))
    (true (search (format nil "NODE~%ALWAYS-TRUE") contents))))
