(in-package #:cl-fast-behavior-trees/tests)


(define-test nodes
  :parent cl-fast-behavior-trees)

(define-test node-smoke-test
  :parent nodes
  (eval
   '(define-behavior-tree-node :test-node-1 ()
     (print "test node 1")))
  (eval
   '(define-behavior-tree-node test-node-2 ()
     (print "test node 2")))
  (true (gethash :test-node-1 fbt::*node-types*))
  (true (gethash 'test-node-2 fbt::*node-types*))
  (of-type fbt::behavior-tree-node (gethash :test-node-1 fbt::*node-types*))
  (of-type fbt::behavior-tree-node (gethash 'test-node-2 fbt::*node-types*))
  (of-type symbol (fbt::behavior-tree-node-function (gethash :test-node-1 fbt::*node-types*)))
  (of-type symbol (fbt::behavior-tree-node-function (gethash 'test-node-2 fbt::*node-types*)))
  (true (fboundp (fbt::behavior-tree-node-function (gethash :test-node-1 fbt::*node-types*))))
  (true (fboundp (fbt::behavior-tree-node-function (gethash 'test-node-2 fbt::*node-types*)))))

(ecs:defcomponent position
  (x 0.0 :type single-float)
  (y 0.0 :type single-float))

(ecs:defcomponent velocity
  (x 0.0 :type single-float)
  (y 0.0 :type single-float))

(defvar *x*)

(define-test node-ro-components
  :parent nodes
  (eval
   '(define-behavior-tree-node (test-node-3 :components-ro (position)) ()
     (setf *x* position-x)))
  (eval
   '(define-behavior-tree test50
     (test-node-3)))
  (ecs:make-storage)
  (setf *x* nil)
  (let* ((x 42.0)
         (entity (ecs:make-object `((:position :x ,x) (:test50)))))
    (declare (ignore entity))
    (ecs:run-systems)
    (is = x *x*)))

(define-test node-ro-components-unwritable
  :parent nodes
  (eval
   '(define-behavior-tree-node (test-node-4 :components-ro (position velocity)) ()
     (incf position-x velocity-x)
     (incf position-y velocity-y)))
  (eval
   '(define-behavior-tree test51
     (test-node-4)))
  (ecs:make-storage)
  (ecs:make-object `((:position) (:velocity) (:test51)))
  (fail (ecs:run-systems)))

(define-test node-rw-components
  :parent nodes
  (eval
   '(define-behavior-tree-node (test-node-5 :components-rw (position velocity)) ()
     (incf position-x velocity-x)
     (incf position-y velocity-y)))
  (eval
   '(define-behavior-tree test52
     (test-node-5)))
  (ecs:make-storage)
  (let* ((d 1.0)
         (entity (ecs:make-object
                  `((:position) (:velocity :x ,d :y ,d) (:test52)))))
    (ecs:run-systems)
    (is = d (position-x entity))
    (is = d (position-y entity))))

(define-test node-no-components
  :parent nodes
  (eval
   '(define-behavior-tree-node (test-node-6 :components-no (position)) ()
     (error "this should not run")))
  (eval
   '(define-behavior-tree test53
     (test-node-6)))
  (ecs:make-storage)
  (ecs:make-object `((:position) (:test53)))
  (finish (ecs:run-systems)))

(define-test node-arguments
  :parent nodes
  (eval
   '(define-behavior-tree-node (test-node-7 :arguments ((x fixnum))) ()
     (setf *x* x)))
  (eval
   '(define-behavior-tree test54
     (test-node-7)))
  (ecs:make-storage)
  (setf *x* nil)
  (ecs:make-object `((:test54)))
  (ecs:run-systems :x 1)
  (is = 1 *x*))

(defvar *y*)

(define-test node-initially
  :parent nodes
  (eval
   '(define-behavior-tree-node (test-node-8 :initially (setf *y* 1)) ()))
  (eval
   '(define-behavior-tree test55
     (test-node-8)))
  (ecs:make-storage)
  (setf *y* nil)
  (ecs:make-object `((:test55)))
  (ecs:run-systems)
  (is = 1 *y*))

(define-test node-finally
  :parent nodes
  (eval
   '(define-behavior-tree-node (test-node-9 :finally (setf *y* 1)) ()))
  (eval
   '(define-behavior-tree test56
     (test-node-9)))
  (ecs:make-storage)
  (setf *y* nil)
  (ecs:make-object `((:test56)))
  (ecs:run-systems)
  (is = 1 *y*))

(define-test node-when
  :parent nodes
  (eval
   '(define-behavior-tree-node (test-node-10 :when (oddp *x*)) ()
     (error "This should not run")))
  (eval
   '(define-behavior-tree-node (test-node-11 :when (evenp *x*)) ()
     (error "This should not run")))
  (eval
   '(define-behavior-tree test57
     (test-node-10
      (test-node-11))))
  (ecs:make-storage)
  (setf *x* 1)
  (ecs:make-object `((:test57)))
  (finish (ecs:run-systems))
  (setf *x* 2)
  (finish (ecs:run-systems))

  (eval
   '(define-behavior-tree test58
     (test-node-11)))
  (ecs:make-object `((:test58)))
  (fail (ecs:run-systems)))

(define-test node-enable
  :parent nodes
  (eval
   '(define-behavior-tree-node (test-node-12 :enable (and (integerp *x*) (oddp *x*))) ()
     (error "This should not run")))
  (eval
   '(define-behavior-tree-node (test-node-13 :enable (and (integerp *x*) (evenp *x*))) ()
     (error "This should not run")))
  (eval
   '(define-behavior-tree test59
     (test-node-12
      (test-node-13))))
  (ecs:make-storage)
  (setf *x* 1)
  (ecs:make-object `((:test59)))
  (finish (ecs:run-systems))
  (setf *x* 2)
  (finish (ecs:run-systems))

  (eval
   '(define-behavior-tree test60
     (test-node-13)))
  (ecs:make-object `((:test60)))
  (fail (ecs:run-systems)))

(ecs:defsystem testsys
  (:components-rw (velocity)
   :components-no (position))
  (incf velocity-x))

(define-test node-after
  :parent nodes
  (eval
   '(define-behavior-tree-node
     (test-node-14 :after (testsys) :components-rw (velocity)) ()
     (setf velocity-x (* velocity-x 2))))
  (eval
   '(define-behavior-tree test61
     (test-node-14)))
  (ecs:make-storage)
  (let ((entity (ecs:make-object `((:test61) (:velocity :x 1.0)))))
    (ecs:run-systems)
    (is = 4.0 (velocity-x entity))))

(define-test node-before
  :parent nodes
  (eval
   '(define-behavior-tree-node
     (test-node-15 :before (testsys) :components-rw (velocity)) ()
     (setf velocity-x (* velocity-x 2))))
  (eval
   '(define-behavior-tree test62
     (test-node-15)))
  (ecs:make-storage)
  (let ((entity (ecs:make-object `((:test62) (:velocity :x 1.0)))))
    (ecs:run-systems)
    (is = 3.0 (velocity-x entity))))

(define-test node-options
  :parent nodes
  (eval
   '(define-behavior-tree-node test-node-16
     ((value -1 :type fixnum)
      (foo -1 :type fixnum))
     (prin1 (+ value foo))))
  (eval
   '(define-behavior-tree test63
     ((test-node-16 :value entity :foo 1))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test63-behavior-tree entity)
    (is string= (prin1-to-string (1+ entity))
        (with-output-to-string (str)
          (let ((*standard-output* str))
            (ecs:run-systems))))))

(define-test node-options-reset
  :parent nodes
  (eval
   '(define-behavior-tree-node test-node-17
     ((value -1 :type fixnum))
     (prin1 value)
     (complete-node t)))
  (eval
   '(define-behavior-tree test64
     (:repeat
      ((test-node-17 :value *x*)))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (setf *x* 1)
    (make-test64-behavior-tree entity)
    (ecs:run-systems)
    (ecs:run-systems)
    (setf *x* 2)
    (ecs:run-systems)
    (ecs:run-systems)
    (is string= (prin1-to-string *x*)
        (with-output-to-string (str)
          (let ((*standard-output* str))
            (ecs:run-systems))))))

(define-test node-slots
  :parent nodes
  (eval
   '(define-behavior-tree-node test-node-18
     ((x 0.0 :type single-float)
      (y 0.0 :type single-float))
     (incf x)
     (incf y)))
  (eval
   '(define-behavior-tree test65
     (test-node-18)))
  (ecs:make-storage)
  (let ((entity (ecs:make-object `((:test65)))))
    (ecs:run-systems)
    (is = 1.0 (test65-test-node-181-x entity))
    (is = 1.0 (test65-test-node-181-y entity))))

(define-test node-slot-docstring
  :parent nodes
  (let ((docstring "X value"))
    (eval
     `(define-behavior-tree-node test-node-19
       ((x 0.0 :type single-float :documentation ,docstring))))
    (eval
     '(define-behavior-tree test66
       (test-node-19)))
    (is string= docstring (documentation #'test66-test-node-191-x 'function))))
