(in-package #:cl-fast-behavior-trees/tests)


(define-test standard-nodes
  :parent cl-fast-behavior-trees)

(define-test test-repeat-node
  :parent standard-nodes
  (eval
   '(define-behavior-tree test100
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test100 entity)
    (is = 0 (test100-current-node entity))
    (is = 1 (test100-root-active entity))
    (is = 0 (test100-root-completed entity))
    (is = 0 (test100-root-succeeded entity))
    (is = 0 (test100-node-active entity))
    (is = 0 (test100-node-completed entity))
    (is = 0 (test100-node-succeeded entity))
    (ecs:run-systems)
    (is = 0 (test100-current-node entity))
    (is = 1 (test100-root-active entity))
    (is = 0 (test100-root-completed entity))
    (is = 0 (test100-root-succeeded entity))
    (is = 0 (test100-node-active entity))
    (is = 0 (test100-node-completed entity))
    (is = 0 (test100-node-succeeded entity))
    (ecs:run-systems)
    (is = 0 (test100-current-node entity))
    (is = 1 (test100-root-active entity))
    (is = 0 (test100-root-completed entity))
    (is = 0 (test100-root-succeeded entity))
    (is = 0 (test100-node-active entity))
    (is = 0 (test100-node-completed entity))
    (is = 0 (test100-node-succeeded entity))))

(define-test test-repeat-until-fail-node
  :parent standard-nodes
  (eval
   '(define-behavior-tree test101
     ((:repeat-until-fail :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test101 entity)
    (is = 0 (test101-current-node entity))
    (is = 1 (test101-root-active entity))
    (is = 0 (test101-root-completed entity))
    (is = 0 (test101-root-succeeded entity))
    (is = 0 (test101-node-active entity))
    (is = 0 (test101-node-completed entity))
    (is = 0 (test101-node-succeeded entity))
    (ecs:run-systems)
    (is = 0 (test101-current-node entity))
    (is = 1 (test101-root-active entity))
    (is = 0 (test101-root-completed entity))
    (is = 0 (test101-root-succeeded entity))
    (is = 0 (test101-node-active entity))
    (is = 0 (test101-node-completed entity))
    (is = 0 (test101-node-succeeded entity)))
  (eval
   '(define-behavior-tree test102
     ((:repeat-until-fail :name "root")
      ((:always-false :name "node")))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test102 entity)
    (is = 0 (test102-current-node entity))
    (is = 1 (test102-root-active entity))
    (is = 0 (test102-root-completed entity))
    (is = 0 (test102-root-succeeded entity))
    (is = 0 (test102-node-active entity))
    (is = 0 (test102-node-completed entity))
    (is = 0 (test102-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test102-current-node entity))
    (is = 0 (test102-root-active entity))
    (is = 1 (test102-root-completed entity))
    (is = 1 (test102-root-succeeded entity))
    (is = 0 (test102-node-active entity))
    (is = 1 (test102-node-completed entity))
    (is = 0 (test102-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test102-current-node entity))
    (is = 0 (test102-root-active entity))
    (is = 1 (test102-root-completed entity))
    (is = 1 (test102-root-succeeded entity))
    (is = 0 (test102-node-active entity))
    (is = 1 (test102-node-completed entity))
    (is = 0 (test102-node-succeeded entity))))

(define-test test-invert-node
  :parent standard-nodes
  (eval
   '(define-behavior-tree test103
     ((:invert :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test103 entity)
    (is = 0 (test103-current-node entity))
    (is = 1 (test103-root-active entity))
    (is = 0 (test103-root-completed entity))
    (is = 0 (test103-root-succeeded entity))
    (is = 0 (test103-node-active entity))
    (is = 0 (test103-node-completed entity))
    (is = 0 (test103-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test103-current-node entity))
    (is = 0 (test103-root-active entity))
    (is = 1 (test103-root-completed entity))
    (is = 0 (test103-root-succeeded entity))
    (is = 0 (test103-node-active entity))
    (is = 1 (test103-node-completed entity))
    (is = 1 (test103-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test103-current-node entity))
    (is = 0 (test103-root-active entity))
    (is = 1 (test103-root-completed entity))
    (is = 0 (test103-root-succeeded entity))
    (is = 0 (test103-node-active entity))
    (is = 1 (test103-node-completed entity))
    (is = 1 (test103-node-succeeded entity)))
  (eval
   '(define-behavior-tree test104
     ((:invert :name "root")
      ((:always-false :name "node")))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test104 entity)
    (is = 0 (test104-current-node entity))
    (is = 1 (test104-root-active entity))
    (is = 0 (test104-root-completed entity))
    (is = 0 (test104-root-succeeded entity))
    (is = 0 (test104-node-active entity))
    (is = 0 (test104-node-completed entity))
    (is = 0 (test104-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test104-current-node entity))
    (is = 0 (test104-root-active entity))
    (is = 1 (test104-root-completed entity))
    (is = 1 (test104-root-succeeded entity))
    (is = 0 (test104-node-active entity))
    (is = 1 (test104-node-completed entity))
    (is = 0 (test104-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test104-current-node entity))
    (is = 0 (test104-root-active entity))
    (is = 1 (test104-root-completed entity))
    (is = 1 (test104-root-succeeded entity))
    (is = 0 (test104-node-active entity))
    (is = 1 (test104-node-completed entity))
    (is = 0 (test104-node-succeeded entity))))

(define-test test-fallback-node
  :parent standard-nodes
  (eval
   '(define-behavior-tree test105
     ((:fallback :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test105 entity)
    (is = 0 (test105-current-node entity))
    (is = 1 (test105-root-active entity))
    (is = 0 (test105-root-completed entity))
    (is = 0 (test105-root-succeeded entity))
    (is = 0 (test105-root-current entity))
    (is = 0 (test105-node-active entity))
    (is = 0 (test105-node-completed entity))
    (is = 0 (test105-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test105-current-node entity))
    (is = 0 (test105-root-active entity))
    (is = 1 (test105-root-completed entity))
    (is = 1 (test105-root-succeeded entity))
    (is = 0 (test105-root-current entity))
    (is = 0 (test105-node-active entity))
    (is = 1 (test105-node-completed entity))
    (is = 1 (test105-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test105-current-node entity))
    (is = 0 (test105-root-active entity))
    (is = 1 (test105-root-completed entity))
    (is = 1 (test105-root-succeeded entity))
    (is = 0 (test105-root-current entity))
    (is = 0 (test105-node-active entity))
    (is = 1 (test105-node-completed entity))
    (is = 1 (test105-node-succeeded entity)))
  (eval
   '(define-behavior-tree test106
     ((:fallback :name "root")
      ((:always-false :name "node")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test106 entity)
    (is = 0 (test106-current-node entity))
    (is = 1 (test106-root-active entity))
    (is = 0 (test106-root-completed entity))
    (is = 0 (test106-root-succeeded entity))
    (is = 0 (test106-root-current entity))
    (is = 0 (test106-node-active entity))
    (is = 0 (test106-node-completed entity))
    (is = 0 (test106-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test106-current-node entity))
    (is = 0 (test106-root-active entity))
    (is = 1 (test106-root-completed entity))
    (is = 0 (test106-root-succeeded entity))
    (is = 1 (test106-root-current entity))
    (is = 0 (test106-node-active entity))
    (is = 1 (test106-node-completed entity))
    (is = 0 (test106-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test106-current-node entity))
    (is = 0 (test106-root-active entity))
    (is = 1 (test106-root-completed entity))
    (is = 0 (test106-root-succeeded entity))
    (is = 1 (test106-root-current entity))
    (is = 0 (test106-node-active entity))
    (is = 1 (test106-node-completed entity))
    (is = 0 (test106-node-succeeded entity)))
  (eval
   '(define-behavior-tree test107
     ((:fallback :name "root")
      ((:always-false :name "node1"))
      ((:always-false :name "node2")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test107 entity)
    (is = 0 (test107-current-node entity))
    (is = 1 (test107-root-active entity))
    (is = 0 (test107-root-completed entity))
    (is = 0 (test107-root-succeeded entity))
    (is = 0 (test107-root-current entity))
    (is = 0 (test107-node1-active entity))
    (is = 0 (test107-node1-completed entity))
    (is = 0 (test107-node1-succeeded entity))
    (is = 0 (test107-node2-active entity))
    (is = 0 (test107-node2-completed entity))
    (is = 0 (test107-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test107-current-node entity))
    (is = 0 (test107-root-active entity))
    (is = 1 (test107-root-completed entity))
    (is = 0 (test107-root-succeeded entity))
    (is = 2 (test107-root-current entity))
    (is = 0 (test107-node1-active entity))
    (is = 1 (test107-node1-completed entity))
    (is = 0 (test107-node1-succeeded entity))
    (is = 0 (test107-node2-active entity))
    (is = 1 (test107-node2-completed entity))
    (is = 0 (test107-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test107-current-node entity))
    (is = 0 (test107-root-active entity))
    (is = 1 (test107-root-completed entity))
    (is = 0 (test107-root-succeeded entity))
    (is = 2 (test107-root-current entity))
    (is = 0 (test107-node1-active entity))
    (is = 1 (test107-node1-completed entity))
    (is = 0 (test107-node1-succeeded entity))
    (is = 0 (test107-node2-active entity))
    (is = 1 (test107-node2-completed entity))
    (is = 0 (test107-node2-succeeded entity)))
  (eval
   '(define-behavior-tree test108
     ((:fallback :name "root")
      ((:always-false :name "node1"))
      ((:always-true :name "node2")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test108 entity)
    (is = 0 (test108-current-node entity))
    (is = 1 (test108-root-active entity))
    (is = 0 (test108-root-completed entity))
    (is = 0 (test108-root-succeeded entity))
    (is = 0 (test108-root-current entity))
    (is = 0 (test108-node1-active entity))
    (is = 0 (test108-node1-completed entity))
    (is = 0 (test108-node1-succeeded entity))
    (is = 0 (test108-node2-active entity))
    (is = 0 (test108-node2-completed entity))
    (is = 0 (test108-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test108-current-node entity))
    (is = 0 (test108-root-active entity))
    (is = 1 (test108-root-completed entity))
    (is = 1 (test108-root-succeeded entity))
    (is = 1 (test108-root-current entity))
    (is = 0 (test108-node1-active entity))
    (is = 1 (test108-node1-completed entity))
    (is = 0 (test108-node1-succeeded entity))
    (is = 0 (test108-node2-active entity))
    (is = 1 (test108-node2-completed entity))
    (is = 1 (test108-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test108-current-node entity))
    (is = 0 (test108-root-active entity))
    (is = 1 (test108-root-completed entity))
    (is = 1 (test108-root-succeeded entity))
    (is = 1 (test108-root-current entity))
    (is = 0 (test108-node1-active entity))
    (is = 1 (test108-node1-completed entity))
    (is = 0 (test108-node1-succeeded entity))
    (is = 0 (test108-node2-active entity))
    (is = 1 (test108-node2-completed entity))
    (is = 1 (test108-node2-succeeded entity)))
  (eval
   '(define-behavior-tree test109
     ((:fallback :name "root")
      ((:always-true :name "node1"))
      ((:always-false :name "node2")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test109 entity)
    (is = 0 (test109-current-node entity))
    (is = 1 (test109-root-active entity))
    (is = 0 (test109-root-completed entity))
    (is = 0 (test109-root-succeeded entity))
    (is = 0 (test109-root-current entity))
    (is = 0 (test109-node1-active entity))
    (is = 0 (test109-node1-completed entity))
    (is = 0 (test109-node1-succeeded entity))
    (is = 0 (test109-node2-active entity))
    (is = 0 (test109-node2-completed entity))
    (is = 0 (test109-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test109-current-node entity))
    (is = 0 (test109-root-active entity))
    (is = 1 (test109-root-completed entity))
    (is = 1 (test109-root-succeeded entity))
    (is = 0 (test109-root-current entity))
    (is = 0 (test109-node1-active entity))
    (is = 1 (test109-node1-completed entity))
    (is = 1 (test109-node1-succeeded entity))
    (is = 0 (test109-node2-active entity))
    (is = 0 (test109-node2-completed entity))
    (is = 0 (test109-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test109-current-node entity))
    (is = 0 (test109-root-active entity))
    (is = 1 (test109-root-completed entity))
    (is = 1 (test109-root-succeeded entity))
    (is = 0 (test109-root-current entity))
    (is = 0 (test109-node1-active entity))
    (is = 1 (test109-node1-completed entity))
    (is = 1 (test109-node1-succeeded entity))
    (is = 0 (test109-node2-active entity))
    (is = 0 (test109-node2-completed entity))
    (is = 0 (test109-node2-succeeded entity))))

(define-test test-sequence-node
  :parent standard-nodes
  (eval
   '(define-behavior-tree test110
     ((:sequence :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test110 entity)
    (is = 0 (test110-current-node entity))
    (is = 1 (test110-root-active entity))
    (is = 0 (test110-root-completed entity))
    (is = 0 (test110-root-succeeded entity))
    (is = 0 (test110-root-current entity))
    (is = 0 (test110-node-active entity))
    (is = 0 (test110-node-completed entity))
    (is = 0 (test110-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test110-current-node entity))
    (is = 0 (test110-root-active entity))
    (is = 1 (test110-root-completed entity))
    (is = 1 (test110-root-succeeded entity))
    (is = 1 (test110-root-current entity))
    (is = 0 (test110-node-active entity))
    (is = 1 (test110-node-completed entity))
    (is = 1 (test110-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test110-current-node entity))
    (is = 0 (test110-root-active entity))
    (is = 1 (test110-root-completed entity))
    (is = 1 (test110-root-succeeded entity))
    (is = 1 (test110-root-current entity))
    (is = 0 (test110-node-active entity))
    (is = 1 (test110-node-completed entity))
    (is = 1 (test110-node-succeeded entity)))
  (eval
   '(define-behavior-tree test111
     ((:sequence :name "root")
      ((:always-false :name "node")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test111 entity)
    (is = 0 (test111-current-node entity))
    (is = 1 (test111-root-active entity))
    (is = 0 (test111-root-completed entity))
    (is = 0 (test111-root-succeeded entity))
    (is = 0 (test111-root-current entity))
    (is = 0 (test111-node-active entity))
    (is = 0 (test111-node-completed entity))
    (is = 0 (test111-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test111-current-node entity))
    (is = 0 (test111-root-active entity))
    (is = 1 (test111-root-completed entity))
    (is = 0 (test111-root-succeeded entity))
    (is = 0 (test111-root-current entity))
    (is = 0 (test111-node-active entity))
    (is = 1 (test111-node-completed entity))
    (is = 0 (test111-node-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test111-current-node entity))
    (is = 0 (test111-root-active entity))
    (is = 1 (test111-root-completed entity))
    (is = 0 (test111-root-succeeded entity))
    (is = 0 (test111-root-current entity))
    (is = 0 (test111-node-active entity))
    (is = 1 (test111-node-completed entity))
    (is = 0 (test111-node-succeeded entity)))
  (eval
   '(define-behavior-tree test112
     ((:sequence :name "root")
      ((:always-true :name "node1"))
      ((:always-true :name "node2")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test112 entity)
    (is = 0 (test112-current-node entity))
    (is = 1 (test112-root-active entity))
    (is = 0 (test112-root-completed entity))
    (is = 0 (test112-root-succeeded entity))
    (is = 0 (test112-root-current entity))
    (is = 0 (test112-node1-active entity))
    (is = 0 (test112-node1-completed entity))
    (is = 0 (test112-node1-succeeded entity))
    (is = 0 (test112-node2-active entity))
    (is = 0 (test112-node2-completed entity))
    (is = 0 (test112-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test112-current-node entity))
    (is = 0 (test112-root-active entity))
    (is = 1 (test112-root-completed entity))
    (is = 1 (test112-root-succeeded entity))
    (is = 2 (test112-root-current entity))
    (is = 0 (test112-node1-active entity))
    (is = 1 (test112-node1-completed entity))
    (is = 1 (test112-node1-succeeded entity))
    (is = 0 (test112-node2-active entity))
    (is = 1 (test112-node2-completed entity))
    (is = 1 (test112-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test112-current-node entity))
    (is = 0 (test112-root-active entity))
    (is = 1 (test112-root-completed entity))
    (is = 1 (test112-root-succeeded entity))
    (is = 2 (test112-root-current entity))
    (is = 0 (test112-node1-active entity))
    (is = 1 (test112-node1-completed entity))
    (is = 1 (test112-node1-succeeded entity))
    (is = 0 (test112-node2-active entity))
    (is = 1 (test112-node2-completed entity))
    (is = 1 (test112-node2-succeeded entity)))
  (eval
   '(define-behavior-tree test113
     ((:sequence :name "root")
      ((:always-true :name "node1"))
      ((:always-false :name "node2")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test113 entity)
    (is = 0 (test113-current-node entity))
    (is = 1 (test113-root-active entity))
    (is = 0 (test113-root-completed entity))
    (is = 0 (test113-root-succeeded entity))
    (is = 0 (test113-root-current entity))
    (is = 0 (test113-node1-active entity))
    (is = 0 (test113-node1-completed entity))
    (is = 0 (test113-node1-succeeded entity))
    (is = 0 (test113-node2-active entity))
    (is = 0 (test113-node2-completed entity))
    (is = 0 (test113-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test113-current-node entity))
    (is = 0 (test113-root-active entity))
    (is = 1 (test113-root-completed entity))
    (is = 0 (test113-root-succeeded entity))
    (is = 1 (test113-root-current entity))
    (is = 0 (test113-node1-active entity))
    (is = 1 (test113-node1-completed entity))
    (is = 1 (test113-node1-succeeded entity))
    (is = 0 (test113-node2-active entity))
    (is = 1 (test113-node2-completed entity))
    (is = 0 (test113-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test113-current-node entity))
    (is = 0 (test113-root-active entity))
    (is = 1 (test113-root-completed entity))
    (is = 0 (test113-root-succeeded entity))
    (is = 1 (test113-root-current entity))
    (is = 0 (test113-node1-active entity))
    (is = 1 (test113-node1-completed entity))
    (is = 1 (test113-node1-succeeded entity))
    (is = 0 (test113-node2-active entity))
    (is = 1 (test113-node2-completed entity))
    (is = 0 (test113-node2-succeeded entity)))
  (eval
   '(define-behavior-tree test114
     ((:sequence :name "root")
      ((:always-false :name "node1"))
      ((:always-true :name "node2")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test114 entity)
    (is = 0 (test114-current-node entity))
    (is = 1 (test114-root-active entity))
    (is = 0 (test114-root-completed entity))
    (is = 0 (test114-root-succeeded entity))
    (is = 0 (test114-root-current entity))
    (is = 0 (test114-node1-active entity))
    (is = 0 (test114-node1-completed entity))
    (is = 0 (test114-node1-succeeded entity))
    (is = 0 (test114-node2-active entity))
    (is = 0 (test114-node2-completed entity))
    (is = 0 (test114-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test114-current-node entity))
    (is = 0 (test114-root-active entity))
    (is = 1 (test114-root-completed entity))
    (is = 0 (test114-root-succeeded entity))
    (is = 0 (test114-root-current entity))
    (is = 0 (test114-node1-active entity))
    (is = 1 (test114-node1-completed entity))
    (is = 0 (test114-node1-succeeded entity))
    (is = 0 (test114-node2-active entity))
    (is = 0 (test114-node2-completed entity))
    (is = 0 (test114-node2-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test114-current-node entity))
    (is = 0 (test114-root-active entity))
    (is = 1 (test114-root-completed entity))
    (is = 0 (test114-root-succeeded entity))
    (is = 0 (test114-root-current entity))
    (is = 0 (test114-node1-active entity))
    (is = 1 (test114-node1-completed entity))
    (is = 0 (test114-node1-succeeded entity))
    (is = 0 (test114-node2-active entity))
    (is = 0 (test114-node2-completed entity))
    (is = 0 (test114-node2-succeeded entity))))

(define-test test-random-node
  :parent standard-nodes
  (eval
   '(define-behavior-tree test115
     (:random)))
  (ecs:make-storage)
  (let* ((entities (loop :for i :below 10 :collect
                            (ecs:make-object `((:test115))))))
    (ecs:run-systems)
    (loop :with successes := 0
          :with failures := 0
          :for entity :in entities
          :do (is = -1 (test115-current-node entity))
              (is = 0 (test115-random1-active entity))
              (is = 1 (test115-random1-completed entity))
          (if (plusp (test115-random1-succeeded entity))
              (incf successes)
              (incf failures))
          :finally
          (true (plusp successes))
          (true (plusp failures)))))

(define-test test-always-true-node
  :parent standard-nodes
  (eval
   '(define-behavior-tree test116
     (:always-true)))
  (ecs:make-storage)
  (let* ((entity (ecs:make-object `((:test116)))))
    (ecs:run-systems)
    (is = -1 (test116-current-node entity))
    (is = 0 (test116-always-true1-active entity))
    (is = 1 (test116-always-true1-completed entity))
    (is = 1 (test116-always-true1-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test116-current-node entity))
    (is = 0 (test116-always-true1-active entity))
    (is = 1 (test116-always-true1-completed entity))
    (is = 1 (test116-always-true1-succeeded entity))))

(define-test test-always-false-node
  :parent standard-nodes
  (eval
   '(define-behavior-tree test117
     (:always-false)))
  (ecs:make-storage)
  (let* ((entity (ecs:make-object `((:test117)))))
    (ecs:run-systems)
    (is = -1 (test117-current-node entity))
    (is = 0 (test117-always-false1-active entity))
    (is = 1 (test117-always-false1-completed entity))
    (is = 0 (test117-always-false1-succeeded entity))
    (ecs:run-systems)
    (is = -1 (test117-current-node entity))
    (is = 0 (test117-always-false1-active entity))
    (is = 1 (test117-always-false1-completed entity))
    (is = 0 (test117-always-false1-succeeded entity))))
