(in-package #:cl-fast-behavior-trees/tests)


(define-test trees
  :parent cl-fast-behavior-trees)

(define-test tree-basic-ctor
  :parent trees
  (eval
   '(define-behavior-tree test1
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let* ((ecs:*skip-printing-components* nil)
         (entity (ecs:make-entity))
         (_ (make-test1 entity))
         (entity-structure (ecs:print-entity entity (make-broadcast-stream)))
         (properties (cdar entity-structure)))
    (declare (ignore _))
    (is = 0 (getf properties :current-node))
    (is = 1 (getf properties :root-active))
    (is = 0 (getf properties :root-completed))
    (is = 0 (getf properties :root-succeeded))
    (is = 0 (getf properties :node-active))
    (is = 0 (getf properties :node-completed))
    (is = 0 (getf properties :node-succeeded))))

(define-test tree-full-ctor
  :parent trees
  (eval
   '(define-behavior-tree test2
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let* ((ecs:*skip-printing-components* nil)
         (entity (ecs:make-entity))
         (_ (make-test2-behavior-tree entity :node-succeeded 1))
         (entity-structure (ecs:print-entity entity (make-broadcast-stream)))
         (properties (cdadr entity-structure)))
    (declare (ignore _))
    (is = 0 (getf properties :current-node))
    (is = 1 (getf properties :root-active))
    (is = 0 (getf properties :root-completed))
    (is = 0 (getf properties :root-succeeded))
    (is = 0 (getf properties :node-active))
    (is = 0 (getf properties :node-completed))
    (is = 1 (getf properties :node-succeeded))

    (true (fbt::has-behavior-tree-marker-p entity))
    (is eq 'test2 (fbt::behavior-tree-marker-type entity))))

(define-test tree-generic-ctor
  :parent trees
  (eval
   '(define-behavior-tree test3
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-behavior-tree 'test3 entity)
    (ecs:run-systems)
    (is = 0 (test3-current-node entity))
    (is = 1 (test3-root-active entity))
    (is = 0 (test3-root-completed entity))
    (is = 0 (test3-node-active entity))
    (is = 0 (test3-node-completed entity))))

(define-test tree-dtor
  :parent trees
  (eval
   '(define-behavior-tree test4
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test4-behavior-tree entity)
    (delete-test4-behavior-tree entity)
    (is equal nil (ecs:print-entity entity (make-broadcast-stream)))))

(define-test tree-generic-dtor
  :parent trees
  (eval
   '(define-behavior-tree test5
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test5-behavior-tree entity)
    (delete-behavior-tree entity)
    (is equal nil (ecs:print-entity entity (make-broadcast-stream)))))

(define-test tree-redefinition
  :parent trees
  (eval
   '(define-behavior-tree test6
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (eval
   '(define-behavior-tree test6
     ((:repeat :name "root")
      ((:fallback :name "fall")
       ((:always-false :name "node"))
       ((:always-true :name "node2"))))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test6 entity)
    (ecs:run-systems)
    (is = 0 (test6-current-node entity))
    (is = 1 (test6-root-active entity))
    (is = 0 (test6-root-completed entity))
    (is = 0 (test6-fall-active entity))
    (is = 0 (test6-fall-completed entity))))

(define-test basic-tree-run
  :parent trees
  (eval
   '(define-behavior-tree test7
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test7 entity)
    (ecs:run-systems)
    (ecs:run-systems)
    (is = 0 (test7-node-completed entity))
    (is = 0 (test7-node-succeeded entity))))

(define-test tree-run
  :parent trees
  (eval
   '(define-behavior-tree test8
     ((:repeat :name "root")
      ((:fallback :name "fall")
       ((:always-false :name "node1"))
       ((:always-true :name "node2"))))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test8 entity)
    (is = 0 (test8-current-node entity))
    (is = 1 (test8-root-active entity))
    (is = 0 (test8-root-completed entity))
    (is = 0 (test8-root-succeeded entity))
    (is = 0 (test8-fall-active entity))
    (is = 0 (test8-fall-completed entity))
    (is = 0 (test8-fall-succeeded entity))
    (is = 0 (test8-node1-active entity))
    (is = 0 (test8-node1-completed entity))
    (is = 0 (test8-node1-succeeded entity))
    (is = 0 (test8-node2-active entity))
    (is = 0 (test8-node2-completed entity))
    (is = 0 (test8-node2-succeeded entity))
    (ecs:run-systems)
    (is = 0 (test8-current-node entity))
    (is = 1 (test8-root-active entity))
    (is = 0 (test8-root-completed entity))
    (is = 0 (test8-root-succeeded entity))
    (is = 0 (test8-fall-active entity))
    (is = 0 (test8-fall-completed entity))
    (is = 0 (test8-fall-succeeded entity))
    (is = 0 (test8-node1-active entity))
    (is = 0 (test8-node1-completed entity))
    (is = 0 (test8-node1-succeeded entity))
    (is = 0 (test8-node2-active entity))
    (is = 0 (test8-node2-completed entity))
    (is = 0 (test8-node2-succeeded entity))))

(define-test node-name-counters
  :parent trees
  (eval
   '(define-behavior-tree test9
     ((:repeat :name "root")
      ((:fallback :name "fall")
       ((:always-false))
       ((:always-true))
       ((:always-false))))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test9 entity)
    (ecs:run-systems)
    (is = 0 (test9-always-false1-active entity))
    (is = 0 (test9-always-false1-completed entity))
    (is = 0 (test9-always-true1-active entity))
    (is = 0 (test9-always-true1-completed entity))
    (is = 0 (test9-always-false2-active entity))
    (is = 0 (test9-always-false2-completed entity))))

(define-test unknow-node-type
  :parent trees
  (fail
   (eval
    `(define-behavior-tree test10
      ((:repeat :name "root")
       ((,(gensym) :name "unknown")))))))

(define-test non-unique-node-names
  :parent trees
  (fail
   (eval
    '(define-behavior-tree test11
      ((:repeat :name "test")
       ((:always-true :name "test")))))))

(define-test optionless-node
  :parent trees
  (eval
   '(define-behavior-tree test12
     (:repeat
      (:always-true))))
  (ecs:make-storage)
  (let* ((entity (ecs:make-entity)))
    (make-test12 entity)
    (ecs:run-systems)
    (is = 0 (test12-current-node entity))
    (is = 1 (test12-repeat1-active entity))
    (is = 0 (test12-repeat1-completed entity))
    (is = 0 (test12-always-true1-active entity))
    (is = 0 (test12-always-true1-completed entity))))

(defvar *debug* nil)

(define-test tree-debugging
  :parent trees
  (eval
   '(define-behavior-tree test13
     (:repeat
      (:always-true))
     :debug (lambda (msg) (push msg *debug*))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-test13 entity)
    (setf *debug* nil)
    (ecs:run-systems)
    (is equalp
        '("TEST13: running REPEAT node REPEAT1 for entity 0"
          "TEST13: ALWAYS-TRUE node ALWAYS-TRUE1 for entity 0 succeeded"
          "TEST13: running ALWAYS-TRUE node ALWAYS-TRUE1 for entity 0"
          "TEST13: running REPEAT node REPEAT1 for entity 0")
        *debug*)))

(define-test tree-debugging-with-print
  :parent trees
  (eval
   '(define-behavior-tree test14
      (:repeat
       (:always-true))
      :debug t))
  (ecs:make-storage)
  (let* ((entity (ecs:make-object `((:test14))))
         (output (with-output-to-string (str)
                   (let ((*standard-output* str))
                     (ecs:run-systems)))))
    (declare (ignore entity))
    (is string=
        "TEST14: running REPEAT node REPEAT1 for entity 0
TEST14: running ALWAYS-TRUE node ALWAYS-TRUE1 for entity 0
TEST14: ALWAYS-TRUE node ALWAYS-TRUE1 for entity 0 succeeded
TEST14: running REPEAT node REPEAT1 for entity 0
"
        output)))

(define-test tree-lazy-initialization
  :parent trees
  (eval
   '(define-behavior-tree test15
     ((:repeat :name "root")
      ((:always-true :name "node")))))
  (ecs:make-storage)
  (let ((entity (ecs:make-entity)))
    (make-behavior-tree-marker entity
                               :type 'cl-fast-behavior-trees/tests::test15)
    (ecs:run-systems)
    (true (has-test15-p entity))))
