;;; This file was automatically generated by SWIG (http://www.swig.org).
;;; Version 3.0.12
;;;
;;; Do not make changes to this file unless you know what you are doing--modify
;;; the SWIG interface file instead.

(in-package :cl-liballegro-nuklear)

(defmacro flags (type &rest flags)
  (let* ((flag-type (intern (string-upcase type) :nk))
         (value (apply #'logior
                       (mapcar
                        #'(lambda (flag)
                            (cffi:foreign-enum-value flag-type flag))
                        flags))))
    value))

(cffi:defcstruct (color :class color)
  (r :unsigned-char)
  (g :unsigned-char)
  (b :unsigned-char)
  (a :unsigned-char))

(cffi:defcstruct (vec-2 :class vec-2)
  (x :float)
  (y :float))

(cffi:defcstruct (rect :class rect)
  (x :float)
  (y :float)
  (w :float)
  (h :float))

(defmacro tree-push (ctx type title state)
  (let ((hash (string (gensym "nk-tree-hash"))))
    `(tree-push-hashed ,ctx ,type ,title ,state ,hash ,(length hash) 0)))

(cffi:defcfun ("nk_rect" rect) (:struct rect)
  (x :float)
  (y :float)
  (w :float)
  (h :float))

(cffi:defcfun ("nk_vec2" vec-2) (:struct vec-2)
 (x :float)
 (y :float))



;;;SWIG wrapper code starts here

(cl:defmacro defanonenum (cl:&body enums)
   "Converts anonymous enums to defconstants."
  `(cl:progn ,@(cl:loop for value in enums
                        for index = 0 then (cl:1+ index)
                        when (cl:listp value) do (cl:setf index (cl:second value)
                                                          value (cl:first value))
                        collect `(cl:defconstant ,value ,index))))

(cl:eval-when (:compile-toplevel :load-toplevel)
  (cl:unless (cl:fboundp 'swig-lispify)
    (cl:defun swig-lispify (name flag cl:&optional (package cl:*package*))
      (cl:labels ((helper (lst last rest cl:&aux (c (cl:car lst)))
                    (cl:cond
                      ((cl:null lst)
                       rest)
                      ((cl:upper-case-p c)
                       (helper (cl:cdr lst) 'upper
                               (cl:case last
                                 ((lower digit) (cl:list* c #\- rest))
                                 (cl:t (cl:cons c rest)))))
                      ((cl:lower-case-p c)
                       (helper (cl:cdr lst) 'lower (cl:cons (cl:char-upcase c) rest)))
                      ((cl:digit-char-p c)
                       (helper (cl:cdr lst) 'digit 
                               (cl:case last
                                 ((upper lower) (cl:list* c #\- rest))
                                 (cl:t (cl:cons c rest)))))
                      ((cl:char-equal c #\_)
                       (helper (cl:cdr lst) '_ (cl:cons #\- rest)))
                      (cl:t
                       (cl:error "Invalid character: ~A" c)))))
        (cl:let ((fix (cl:case flag
                        ((constant enumvalue) "+")
                        (variable "*")
                        (cl:t ""))))
          (cl:intern
           (cl:concatenate
            'cl:string
            fix
            (cl:nreverse (helper (cl:concatenate 'cl:list name) cl:nil cl:nil))
            fix)
           package))))))

;;;SWIG wrapper code ends here


(defanonenum 
	#.(swig-lispify "false" 'enumvalue)
	#.(swig-lispify "true" 'enumvalue))

(cffi:defcstruct (#.(swig-lispify "color" 'classname) :class #.(swig-lispify "color" 'classname))
	(#.(swig-lispify "r" 'slotname) :unsigned-char)
	(#.(swig-lispify "g" 'slotname) :unsigned-char)
	(#.(swig-lispify "b" 'slotname) :unsigned-char)
	(#.(swig-lispify "a" 'slotname) :unsigned-char))

(cffi:defcstruct (#.(swig-lispify "colorf" 'classname) :class #.(swig-lispify "colorf" 'classname))
	(#.(swig-lispify "r" 'slotname) :float)
	(#.(swig-lispify "g" 'slotname) :float)
	(#.(swig-lispify "b" 'slotname) :float)
	(#.(swig-lispify "a" 'slotname) :float))

(cffi:defcstruct (#.(swig-lispify "vec2" 'classname) :class #.(swig-lispify "vec2" 'classname))
	(#.(swig-lispify "x" 'slotname) :float)
	(#.(swig-lispify "y" 'slotname) :float))

(cffi:defcstruct (#.(swig-lispify "rect" 'classname) :class #.(swig-lispify "rect" 'classname))
	(#.(swig-lispify "x" 'slotname) :float)
	(#.(swig-lispify "y" 'slotname) :float)
	(#.(swig-lispify "w" 'slotname) :float)
	(#.(swig-lispify "h" 'slotname) :float))

(cffi:defcstruct (#.(swig-lispify "image" 'classname) :class #.(swig-lispify "image" 'classname))
	(#.(swig-lispify "handle" 'slotname) :pointer)
	(#.(swig-lispify "w" 'slotname) :unsigned-short)
	(#.(swig-lispify "h" 'slotname) :unsigned-short)
	(#.(swig-lispify "region" 'slotname) :uint64))

(cffi:defcstruct (#.(swig-lispify "nine_slice" 'classname) :class #.(swig-lispify "nine_slice" 'classname))
	(#.(swig-lispify "img" 'slotname) (:struct #.(swig-lispify "image" 'classname)))
	(#.(swig-lispify "l" 'slotname) :unsigned-short)
	(#.(swig-lispify "t" 'slotname) :unsigned-short)
	(#.(swig-lispify "r" 'slotname) :unsigned-short)
	(#.(swig-lispify "b" 'slotname) :unsigned-short))

(cffi:defcstruct (#.(swig-lispify "cursor" 'classname) :class #.(swig-lispify "cursor" 'classname))
	(#.(swig-lispify "img" 'slotname) (:struct #.(swig-lispify "image" 'classname)))
	(#.(swig-lispify "size" 'slotname) (:struct #.(swig-lispify "vec2" 'classname)))
	(#.(swig-lispify "offset" 'slotname) (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcstruct (#.(swig-lispify "scroll" 'classname) :class #.(swig-lispify "scroll" 'classname))
	(#.(swig-lispify "x" 'slotname) :unsigned-int)
	(#.(swig-lispify "y" 'slotname) :unsigned-int))

(cffi:defcenum #.(swig-lispify "heading" 'enumname)
	#.(swig-lispify "UP" 'enumvalue :keyword)
	#.(swig-lispify "RIGHT" 'enumvalue :keyword)
	#.(swig-lispify "DOWN" 'enumvalue :keyword)
	#.(swig-lispify "LEFT" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "button_behavior" 'enumname)
	#.(swig-lispify "BUTTON_DEFAULT" 'enumvalue :keyword)
	#.(swig-lispify "BUTTON_REPEATER" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "modify" 'enumname)
	#.(swig-lispify "FIXED" 'enumvalue :keyword)
	#.(swig-lispify "MODIFIABLE" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "orientation" 'enumname)
	#.(swig-lispify "VERTICAL" 'enumvalue :keyword)
	#.(swig-lispify "HORIZONTAL" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "collapse_states" 'enumname)
	#.(swig-lispify "MINIMIZED" 'enumvalue :keyword)
	#.(swig-lispify "MAXIMIZED" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "show_states" 'enumname)
	#.(swig-lispify "HIDDEN" 'enumvalue :keyword)
	#.(swig-lispify "SHOWN" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "chart_type" 'enumname)
	#.(swig-lispify "CHART_LINES" 'enumvalue :keyword)
	#.(swig-lispify "CHART_COLUMN" 'enumvalue :keyword)
	#.(swig-lispify "CHART_MAX" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "chart_event" 'enumname)
	(#.(swig-lispify "CHART_HOVERING" 'enumvalue :keyword) #.#x01)
	(#.(swig-lispify "CHART_CLICKED" 'enumvalue :keyword) #.#x02))

(cffi:defcenum #.(swig-lispify "color_format" 'enumname)
	#.(swig-lispify "RGB" 'enumvalue :keyword)
	#.(swig-lispify "RGBA" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "popup_type" 'enumname)
	#.(swig-lispify "POPUP_STATIC" 'enumvalue :keyword)
	#.(swig-lispify "POPUP_DYNAMIC" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "layout_format" 'enumname)
	#.(swig-lispify "DYNAMIC" 'enumvalue :keyword)
	#.(swig-lispify "STATIC" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "tree_type" 'enumname)
	#.(swig-lispify "TREE_NODE" 'enumvalue :keyword)
	#.(swig-lispify "TREE_TAB" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "symbol_type" 'enumname)
	#.(swig-lispify "SYMBOL_NONE" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_X" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_UNDERSCORE" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_CIRCLE_SOLID" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_CIRCLE_OUTLINE" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_RECT_SOLID" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_RECT_OUTLINE" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_TRIANGLE_UP" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_TRIANGLE_DOWN" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_TRIANGLE_LEFT" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_TRIANGLE_RIGHT" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_PLUS" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_MINUS" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_TRIANGLE_UP_OUTLINE" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_TRIANGLE_DOWN_OUTLINE" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_TRIANGLE_LEFT_OUTLINE" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_TRIANGLE_RIGHT_OUTLINE" 'enumvalue :keyword)
	#.(swig-lispify "SYMBOL_MAX" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "keys" 'enumname)
	#.(swig-lispify "KEY_NONE" 'enumvalue :keyword)
	#.(swig-lispify "KEY_SHIFT" 'enumvalue :keyword)
	#.(swig-lispify "KEY_CTRL" 'enumvalue :keyword)
	#.(swig-lispify "KEY_DEL" 'enumvalue :keyword)
	#.(swig-lispify "KEY_ENTER" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TAB" 'enumvalue :keyword)
	#.(swig-lispify "KEY_BACKSPACE" 'enumvalue :keyword)
	#.(swig-lispify "KEY_COPY" 'enumvalue :keyword)
	#.(swig-lispify "KEY_CUT" 'enumvalue :keyword)
	#.(swig-lispify "KEY_PASTE" 'enumvalue :keyword)
	#.(swig-lispify "KEY_UP" 'enumvalue :keyword)
	#.(swig-lispify "KEY_DOWN" 'enumvalue :keyword)
	#.(swig-lispify "KEY_LEFT" 'enumvalue :keyword)
	#.(swig-lispify "KEY_RIGHT" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_INSERT_MODE" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_REPLACE_MODE" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_RESET_MODE" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_LINE_START" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_LINE_END" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_START" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_END" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_UNDO" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_REDO" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_SELECT_ALL" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_WORD_LEFT" 'enumvalue :keyword)
	#.(swig-lispify "KEY_TEXT_WORD_RIGHT" 'enumvalue :keyword)
	#.(swig-lispify "KEY_SCROLL_START" 'enumvalue :keyword)
	#.(swig-lispify "KEY_SCROLL_END" 'enumvalue :keyword)
	#.(swig-lispify "KEY_SCROLL_DOWN" 'enumvalue :keyword)
	#.(swig-lispify "KEY_SCROLL_UP" 'enumvalue :keyword)
	#.(swig-lispify "KEY_MAX" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "buttons" 'enumname)
	#.(swig-lispify "BUTTON_LEFT" 'enumvalue :keyword)
	#.(swig-lispify "BUTTON_MIDDLE" 'enumvalue :keyword)
	#.(swig-lispify "BUTTON_RIGHT" 'enumvalue :keyword)
	#.(swig-lispify "BUTTON_DOUBLE" 'enumvalue :keyword)
	#.(swig-lispify "BUTTON_MAX" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "panel_flags" 'enumname)
	(#.(swig-lispify "WINDOW_BORDER" 'enumvalue :keyword) #.1)
	(#.(swig-lispify "WINDOW_MOVABLE" 'enumvalue :keyword) #.2)
	(#.(swig-lispify "WINDOW_SCALABLE" 'enumvalue :keyword) #.4)
	(#.(swig-lispify "WINDOW_CLOSABLE" 'enumvalue :keyword) #.8)
	(#.(swig-lispify "WINDOW_MINIMIZABLE" 'enumvalue :keyword) #.16)
	(#.(swig-lispify "WINDOW_NO_SCROLLBAR" 'enumvalue :keyword) #.32)
	(#.(swig-lispify "WINDOW_TITLE" 'enumvalue :keyword) #.64)
	(#.(swig-lispify "WINDOW_SCROLL_AUTO_HIDE" 'enumvalue :keyword) #.128)
	(#.(swig-lispify "WINDOW_BACKGROUND" 'enumvalue :keyword) #.256)
	(#.(swig-lispify "WINDOW_SCALE_LEFT" 'enumvalue :keyword) #.512)
	(#.(swig-lispify "WINDOW_NO_INPUT" 'enumvalue :keyword) #.1024))

(cffi:defcenum #.(swig-lispify "widget_layout_states" 'enumname)
	#.(swig-lispify "WIDGET_INVALID" 'enumvalue :keyword)
	#.(swig-lispify "WIDGET_VALID" 'enumvalue :keyword)
	#.(swig-lispify "WIDGET_ROM" 'enumvalue :keyword)
	#.(swig-lispify "WIDGET_DISABLED" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "widget_states" 'enumname)
	(#.(swig-lispify "WIDGET_STATE_MODIFIED" 'enumvalue :keyword) #.2)
	(#.(swig-lispify "WIDGET_STATE_INACTIVE" 'enumvalue :keyword) #.4)
	(#.(swig-lispify "WIDGET_STATE_ENTERED" 'enumvalue :keyword) #.8)
	(#.(swig-lispify "WIDGET_STATE_HOVER" 'enumvalue :keyword) #.16)
	(#.(swig-lispify "WIDGET_STATE_ACTIVED" 'enumvalue :keyword) #.32)
	(#.(swig-lispify "WIDGET_STATE_LEFT" 'enumvalue :keyword) #.64)
	(#.(swig-lispify "WIDGET_STATE_HOVERED" 'enumvalue :keyword) #.18)
	(#.(swig-lispify "WIDGET_STATE_ACTIVE" 'enumvalue :keyword) #.34))

(cffi:defcenum #.(swig-lispify "text_align" 'enumname)
	(#.(swig-lispify "TEXT_ALIGN_LEFT" 'enumvalue :keyword) #.#x01)
	(#.(swig-lispify "TEXT_ALIGN_CENTERED" 'enumvalue :keyword) #.#x02)
	(#.(swig-lispify "TEXT_ALIGN_RIGHT" 'enumvalue :keyword) #.#x04)
	(#.(swig-lispify "TEXT_ALIGN_TOP" 'enumvalue :keyword) #.#x08)
	(#.(swig-lispify "TEXT_ALIGN_MIDDLE" 'enumvalue :keyword) #.#x10)
	(#.(swig-lispify "TEXT_ALIGN_BOTTOM" 'enumvalue :keyword) #.#x20))

(cffi:defcenum #.(swig-lispify "text_alignment" 'enumname)
	(#.(swig-lispify "TEXT_LEFT" 'enumvalue :keyword) #.17)
	(#.(swig-lispify "TEXT_CENTERED" 'enumvalue :keyword) #.18)
	(#.(swig-lispify "TEXT_RIGHT" 'enumvalue :keyword) #.20))

(cffi:defcenum #.(swig-lispify "edit_flags" 'enumname)
	(#.(swig-lispify "EDIT_DEFAULT" 'enumvalue :keyword) #.0)
	(#.(swig-lispify "EDIT_READ_ONLY" 'enumvalue :keyword) #.1)
	(#.(swig-lispify "EDIT_AUTO_SELECT" 'enumvalue :keyword) #.2)
	(#.(swig-lispify "EDIT_SIG_ENTER" 'enumvalue :keyword) #.4)
	(#.(swig-lispify "EDIT_ALLOW_TAB" 'enumvalue :keyword) #.8)
	(#.(swig-lispify "EDIT_NO_CURSOR" 'enumvalue :keyword) #.16)
	(#.(swig-lispify "EDIT_SELECTABLE" 'enumvalue :keyword) #.32)
	(#.(swig-lispify "EDIT_CLIPBOARD" 'enumvalue :keyword) #.64)
	(#.(swig-lispify "EDIT_CTRL_ENTER_NEWLINE" 'enumvalue :keyword) #.128)
	(#.(swig-lispify "EDIT_NO_HORIZONTAL_SCROLL" 'enumvalue :keyword) #.256)
	(#.(swig-lispify "EDIT_ALWAYS_INSERT_MODE" 'enumvalue :keyword) #.512)
	(#.(swig-lispify "EDIT_MULTILINE" 'enumvalue :keyword) #.1024)
	(#.(swig-lispify "EDIT_GOTO_END_ON_ACTIVATE" 'enumvalue :keyword) #.2048)
	(#.(swig-lispify "EDIT_SIMPLE" 'enumvalue :keyword) #.512)
	(#.(swig-lispify "EDIT_FIELD" 'enumvalue :keyword) #.608)
	(#.(swig-lispify "EDIT_BOX" 'enumvalue :keyword) #.1640)
	(#.(swig-lispify "EDIT_EDITOR" 'enumvalue :keyword) #.1128))

(cffi:defcenum #.(swig-lispify "edit_events" 'enumname)
	(#.(swig-lispify "EDIT_ACTIVE" 'enumvalue :keyword) #.1)
	(#.(swig-lispify "EDIT_INACTIVE" 'enumvalue :keyword) #.2)
	(#.(swig-lispify "EDIT_ACTIVATED" 'enumvalue :keyword) #.4)
	(#.(swig-lispify "EDIT_DEACTIVATED" 'enumvalue :keyword) #.8)
	(#.(swig-lispify "EDIT_COMMITED" 'enumvalue :keyword) #.16))

(cffi:defcenum #.(swig-lispify "style_colors" 'enumname)
	#.(swig-lispify "COLOR_TEXT" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_WINDOW" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_HEADER" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_BORDER" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_BUTTON" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_BUTTON_HOVER" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_BUTTON_ACTIVE" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_TOGGLE" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_TOGGLE_HOVER" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_TOGGLE_CURSOR" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SELECT" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SELECT_ACTIVE" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SLIDER" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SLIDER_CURSOR" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SLIDER_CURSOR_HOVER" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SLIDER_CURSOR_ACTIVE" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_PROPERTY" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_EDIT" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_EDIT_CURSOR" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_COMBO" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_CHART" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_CHART_COLOR" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_CHART_COLOR_HIGHLIGHT" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SCROLLBAR" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SCROLLBAR_CURSOR" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SCROLLBAR_CURSOR_HOVER" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_SCROLLBAR_CURSOR_ACTIVE" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_TAB_HEADER" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_KNOB" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_KNOB_CURSOR" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_KNOB_CURSOR_HOVER" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_KNOB_CURSOR_ACTIVE" 'enumvalue :keyword)
	#.(swig-lispify "COLOR_COUNT" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "style_cursor" 'enumname)
	#.(swig-lispify "CURSOR_ARROW" 'enumvalue :keyword)
	#.(swig-lispify "CURSOR_TEXT" 'enumvalue :keyword)
	#.(swig-lispify "CURSOR_MOVE" 'enumvalue :keyword)
	#.(swig-lispify "CURSOR_RESIZE_VERTICAL" 'enumvalue :keyword)
	#.(swig-lispify "CURSOR_RESIZE_HORIZONTAL" 'enumvalue :keyword)
	#.(swig-lispify "CURSOR_RESIZE_TOP_LEFT_DOWN_RIGHT" 'enumvalue :keyword)
	#.(swig-lispify "CURSOR_RESIZE_TOP_RIGHT_DOWN_LEFT" 'enumvalue :keyword)
	#.(swig-lispify "CURSOR_COUNT" 'enumvalue :keyword))

(cffi:defcenum #.(swig-lispify "style_item_type" 'enumname)
	#.(swig-lispify "STYLE_ITEM_COLOR" 'enumvalue :keyword)
	#.(swig-lispify "STYLE_ITEM_IMAGE" 'enumvalue :keyword)
	#.(swig-lispify "STYLE_ITEM_NINE_SLICE" 'enumvalue :keyword))

(cffi:defcunion #.(swig-lispify "style_item_data" 'classname)
	(#.(swig-lispify "color" 'slotname) (:struct #.(swig-lispify "color" 'classname)))
	(#.(swig-lispify "image" 'slotname) (:struct #.(swig-lispify "image" 'classname)))
	(#.(swig-lispify "slice" 'slotname) (:struct #.(swig-lispify "nine_slice" 'classname))))

(cffi:defcstruct (#.(swig-lispify "style_item" 'classname) :class #.(swig-lispify "style_item" 'classname))
	(#.(swig-lispify "type" 'slotname) #.(swig-lispify "style_item_type" 'enumname))
	(#.(swig-lispify "data" 'slotname) (:struct #.(swig-lispify "nine_slice" 'classname))))

(cffi:defcfun ("nk_init_default" #.(swig-lispify "init_default" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer))

(cffi:defcfun ("nk_init_fixed" #.(swig-lispify "init_fixed" 'function)) :int
  (arg0 :pointer)
  (memory :pointer)
  (size :unsigned-long)
  (arg3 :pointer))

(cffi:defcfun ("nk_init" #.(swig-lispify "init" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 :pointer))

(cffi:defcfun ("nk_init_custom" #.(swig-lispify "init_custom" 'function)) :int
  (arg0 :pointer)
  (cmds :pointer)
  (pool :pointer)
  (arg3 :pointer))

(cffi:defcfun ("nk_clear" #.(swig-lispify "clear" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_free" #.(swig-lispify "free" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_input_begin" #.(swig-lispify "input_begin" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_input_motion" #.(swig-lispify "input_motion" 'function)) :void
  (arg0 :pointer)
  (x :int)
  (y :int))

(cffi:defcfun ("nk_input_key" #.(swig-lispify "input_key" 'function)) :void
  (arg0 :pointer)
  (arg1 #.(swig-lispify "keys" 'enumname))
  (down :int))

(cffi:defcfun ("nk_input_button" #.(swig-lispify "input_button" 'function)) :void
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname))
  (x :int)
  (y :int)
  (down :int))

(cffi:defcfun ("nk_input_scroll" #.(swig-lispify "input_scroll" 'function)) :void
  (arg0 :pointer)
  (val (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_input_char" #.(swig-lispify "input_char" 'function)) :void
  (arg0 :pointer)
  (arg1 :char))

(cffi:defcfun ("nk_input_glyph" #.(swig-lispify "input_glyph" 'function)) :void
  (arg0 :pointer)
  (arg1 :pointer))

(cffi:defcfun ("nk_input_unicode" #.(swig-lispify "input_unicode" 'function)) :void
  (arg0 :pointer)
  (arg1 :unsigned-int))

(cffi:defcfun ("nk_input_end" #.(swig-lispify "input_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_begin" #.(swig-lispify "begin" 'function)) :int
  (ctx :pointer)
  (title :string)
  (bounds (:struct #.(swig-lispify "rect" 'classname)))
  (flags :unsigned-int))

(cffi:defcfun ("nk_begin_titled" #.(swig-lispify "begin_titled" 'function)) :int
  (ctx :pointer)
  (name :string)
  (title :string)
  (bounds (:struct #.(swig-lispify "rect" 'classname)))
  (flags :unsigned-int))

(cffi:defcfun ("nk_end" #.(swig-lispify "end" 'function)) :void
  (ctx :pointer))

(cffi:defcfun ("nk_window_find" #.(swig-lispify "window_find" 'function)) :pointer
  (ctx :pointer)
  (name :string))

(cffi:defcfun ("nk_window_get_bounds" #.(swig-lispify "window_get_bounds" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (ctx :pointer))

(cffi:defcfun ("nk_window_get_position" #.(swig-lispify "window_get_position" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (ctx :pointer))

(cffi:defcfun ("nk_window_get_size" #.(swig-lispify "window_get_size" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_window_get_width" #.(swig-lispify "window_get_width" 'function)) :float
  (arg0 :pointer))

(cffi:defcfun ("nk_window_get_height" #.(swig-lispify "window_get_height" 'function)) :float
  (arg0 :pointer))

(cffi:defcfun ("nk_window_get_panel" #.(swig-lispify "window_get_panel" 'function)) :pointer
  (arg0 :pointer))

(cffi:defcfun ("nk_window_get_content_region" #.(swig-lispify "window_get_content_region" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_window_get_content_region_min" #.(swig-lispify "window_get_content_region_min" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_window_get_content_region_max" #.(swig-lispify "window_get_content_region_max" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_window_get_content_region_size" #.(swig-lispify "window_get_content_region_size" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_window_get_canvas" #.(swig-lispify "window_get_canvas" 'function)) :pointer
  (arg0 :pointer))

(cffi:defcfun ("nk_window_get_scroll" #.(swig-lispify "window_get_scroll" 'function)) :void
  (arg0 :pointer)
  (offset_x :pointer)
  (offset_y :pointer))

(cffi:defcfun ("nk_window_has_focus" #.(swig-lispify "window_has_focus" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_window_is_hovered" #.(swig-lispify "window_is_hovered" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_window_is_collapsed" #.(swig-lispify "window_is_collapsed" 'function)) :int
  (ctx :pointer)
  (name :string))

(cffi:defcfun ("nk_window_is_closed" #.(swig-lispify "window_is_closed" 'function)) :int
  (arg0 :pointer)
  (arg1 :string))

(cffi:defcfun ("nk_window_is_hidden" #.(swig-lispify "window_is_hidden" 'function)) :int
  (arg0 :pointer)
  (arg1 :string))

(cffi:defcfun ("nk_window_is_active" #.(swig-lispify "window_is_active" 'function)) :int
  (arg0 :pointer)
  (arg1 :string))

(cffi:defcfun ("nk_window_is_any_hovered" #.(swig-lispify "window_is_any_hovered" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_item_is_any_active" #.(swig-lispify "item_is_any_active" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_window_set_bounds" #.(swig-lispify "window_set_bounds" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (bounds (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_window_set_position" #.(swig-lispify "window_set_position" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (pos (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_window_set_size" #.(swig-lispify "window_set_size" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (arg2 (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_window_set_focus" #.(swig-lispify "window_set_focus" 'function)) :void
  (arg0 :pointer)
  (name :string))

(cffi:defcfun ("nk_window_set_scroll" #.(swig-lispify "window_set_scroll" 'function)) :void
  (arg0 :pointer)
  (offset_x :unsigned-int)
  (offset_y :unsigned-int))

(cffi:defcfun ("nk_window_close" #.(swig-lispify "window_close" 'function)) :void
  (ctx :pointer)
  (name :string))

(cffi:defcfun ("nk_window_collapse" #.(swig-lispify "window_collapse" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (state #.(swig-lispify "collapse_states" 'enumname)))

(cffi:defcfun ("nk_window_collapse_if" #.(swig-lispify "window_collapse_if" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (arg2 #.(swig-lispify "collapse_states" 'enumname))
  (cond :int))

(cffi:defcfun ("nk_window_show" #.(swig-lispify "window_show" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (arg2 #.(swig-lispify "show_states" 'enumname)))

(cffi:defcfun ("nk_window_show_if" #.(swig-lispify "window_show_if" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (arg2 #.(swig-lispify "show_states" 'enumname))
  (cond :int))

(cffi:defcfun ("nk_rule_horizontal" #.(swig-lispify "rule_horizontal" 'function)) :void
  (ctx :pointer)
  (color (:struct #.(swig-lispify "color" 'classname)))
  (rounding :int))

(cffi:defcfun ("nk_layout_set_min_row_height" #.(swig-lispify "layout_set_min_row_height" 'function)) :void
  (arg0 :pointer)
  (height :float))

(cffi:defcfun ("nk_layout_reset_min_row_height" #.(swig-lispify "layout_reset_min_row_height" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_layout_widget_bounds" #.(swig-lispify "layout_widget_bounds" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_layout_ratio_from_pixel" #.(swig-lispify "layout_ratio_from_pixel" 'function)) :float
  (arg0 :pointer)
  (pixel_width :float))

(cffi:defcfun ("nk_layout_row_dynamic" #.(swig-lispify "layout_row_dynamic" 'function)) :void
  (ctx :pointer)
  (height :float)
  (cols :int))

(cffi:defcfun ("nk_layout_row_static" #.(swig-lispify "layout_row_static" 'function)) :void
  (ctx :pointer)
  (height :float)
  (item_width :int)
  (cols :int))

(cffi:defcfun ("nk_layout_row_begin" #.(swig-lispify "layout_row_begin" 'function)) :void
  (ctx :pointer)
  (fmt #.(swig-lispify "layout_format" 'enumname))
  (row_height :float)
  (cols :int))

(cffi:defcfun ("nk_layout_row_push" #.(swig-lispify "layout_row_push" 'function)) :void
  (arg0 :pointer)
  (value :float))

(cffi:defcfun ("nk_layout_row_end" #.(swig-lispify "layout_row_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_layout_row" #.(swig-lispify "layout_row" 'function)) :void
  (arg0 :pointer)
  (arg1 #.(swig-lispify "layout_format" 'enumname))
  (height :float)
  (cols :int)
  (ratio :pointer))

(cffi:defcfun ("nk_layout_row_template_begin" #.(swig-lispify "layout_row_template_begin" 'function)) :void
  (arg0 :pointer)
  (row_height :float))

(cffi:defcfun ("nk_layout_row_template_push_dynamic" #.(swig-lispify "layout_row_template_push_dynamic" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_layout_row_template_push_variable" #.(swig-lispify "layout_row_template_push_variable" 'function)) :void
  (arg0 :pointer)
  (min_width :float))

(cffi:defcfun ("nk_layout_row_template_push_static" #.(swig-lispify "layout_row_template_push_static" 'function)) :void
  (arg0 :pointer)
  (width :float))

(cffi:defcfun ("nk_layout_row_template_end" #.(swig-lispify "layout_row_template_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_layout_space_begin" #.(swig-lispify "layout_space_begin" 'function)) :void
  (arg0 :pointer)
  (arg1 #.(swig-lispify "layout_format" 'enumname))
  (height :float)
  (widget_count :int))

(cffi:defcfun ("nk_layout_space_push" #.(swig-lispify "layout_space_push" 'function)) :void
  (arg0 :pointer)
  (bounds (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_layout_space_end" #.(swig-lispify "layout_space_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_layout_space_bounds" #.(swig-lispify "layout_space_bounds" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_layout_space_to_screen" #.(swig-lispify "layout_space_to_screen" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_layout_space_to_local" #.(swig-lispify "layout_space_to_local" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_layout_space_rect_to_screen" #.(swig-lispify "layout_space_rect_to_screen" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_layout_space_rect_to_local" #.(swig-lispify "layout_space_rect_to_local" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_spacer" #.(swig-lispify "spacer" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_group_begin" #.(swig-lispify "group_begin" 'function)) :int
  (arg0 :pointer)
  (title :string)
  (arg2 :unsigned-int))

(cffi:defcfun ("nk_group_begin_titled" #.(swig-lispify "group_begin_titled" 'function)) :int
  (arg0 :pointer)
  (name :string)
  (title :string)
  (arg3 :unsigned-int))

(cffi:defcfun ("nk_group_end" #.(swig-lispify "group_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_group_scrolled_offset_begin" #.(swig-lispify "group_scrolled_offset_begin" 'function)) :int
  (arg0 :pointer)
  (x_offset :pointer)
  (y_offset :pointer)
  (title :string)
  (flags :unsigned-int))

(cffi:defcfun ("nk_group_scrolled_begin" #.(swig-lispify "group_scrolled_begin" 'function)) :int
  (arg0 :pointer)
  (off :pointer)
  (title :string)
  (arg3 :unsigned-int))

(cffi:defcfun ("nk_group_scrolled_end" #.(swig-lispify "group_scrolled_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_group_get_scroll" #.(swig-lispify "group_get_scroll" 'function)) :void
  (arg0 :pointer)
  (id :string)
  (x_offset :pointer)
  (y_offset :pointer))

(cffi:defcfun ("nk_group_set_scroll" #.(swig-lispify "group_set_scroll" 'function)) :void
  (arg0 :pointer)
  (id :string)
  (x_offset :unsigned-int)
  (y_offset :unsigned-int))

(cffi:defcfun ("nk_tree_push_hashed" #.(swig-lispify "tree_push_hashed" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "tree_type" 'enumname))
  (title :string)
  (initial_state #.(swig-lispify "collapse_states" 'enumname))
  (hash :string)
  (len :int)
  (seed :int))

(cffi:defcfun ("nk_tree_image_push_hashed" #.(swig-lispify "tree_image_push_hashed" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "tree_type" 'enumname))
  (arg2 (:struct #.(swig-lispify "image" 'classname)))
  (title :string)
  (initial_state #.(swig-lispify "collapse_states" 'enumname))
  (hash :string)
  (len :int)
  (seed :int))

(cffi:defcfun ("nk_tree_pop" #.(swig-lispify "tree_pop" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_tree_state_push" #.(swig-lispify "tree_state_push" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "tree_type" 'enumname))
  (title :string)
  (state :pointer))

(cffi:defcfun ("nk_tree_state_image_push" #.(swig-lispify "tree_state_image_push" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "tree_type" 'enumname))
  (arg2 (:struct #.(swig-lispify "image" 'classname)))
  (title :string)
  (state :pointer))

(cffi:defcfun ("nk_tree_state_pop" #.(swig-lispify "tree_state_pop" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_tree_element_push_hashed" #.(swig-lispify "tree_element_push_hashed" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "tree_type" 'enumname))
  (title :string)
  (initial_state #.(swig-lispify "collapse_states" 'enumname))
  (selected :pointer)
  (hash :string)
  (len :int)
  (seed :int))

(cffi:defcfun ("nk_tree_element_image_push_hashed" #.(swig-lispify "tree_element_image_push_hashed" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "tree_type" 'enumname))
  (arg2 (:struct #.(swig-lispify "image" 'classname)))
  (title :string)
  (initial_state #.(swig-lispify "collapse_states" 'enumname))
  (selected :pointer)
  (hash :string)
  (len :int)
  (seed :int))

(cffi:defcfun ("nk_tree_element_pop" #.(swig-lispify "tree_element_pop" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_list_view_begin" #.(swig-lispify "list_view_begin" 'function)) :int
  (arg0 :pointer)
  (out :pointer)
  (id :string)
  (arg3 :unsigned-int)
  (row_height :int)
  (row_count :int))

(cffi:defcfun ("nk_list_view_end" #.(swig-lispify "list_view_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_widget" #.(swig-lispify "widget" 'function)) #.(swig-lispify "widget_layout_states" 'enumname)
  (arg0 :pointer)
  (arg1 :pointer))

(cffi:defcfun ("nk_widget_fitting" #.(swig-lispify "widget_fitting" 'function)) #.(swig-lispify "widget_layout_states" 'enumname)
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_widget_bounds" #.(swig-lispify "widget_bounds" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_widget_position" #.(swig-lispify "widget_position" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_widget_size" #.(swig-lispify "widget_size" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_widget_width" #.(swig-lispify "widget_width" 'function)) :float
  (arg0 :pointer))

(cffi:defcfun ("nk_widget_height" #.(swig-lispify "widget_height" 'function)) :float
  (arg0 :pointer))

(cffi:defcfun ("nk_widget_is_hovered" #.(swig-lispify "widget_is_hovered" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_widget_is_mouse_clicked" #.(swig-lispify "widget_is_mouse_clicked" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname)))

(cffi:defcfun ("nk_widget_has_mouse_click_down" #.(swig-lispify "widget_has_mouse_click_down" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname))
  (down :int))

(cffi:defcfun ("nk_spacing" #.(swig-lispify "spacing" 'function)) :void
  (arg0 :pointer)
  (cols :int))

(cffi:defcfun ("nk_widget_disable_begin" #.(swig-lispify "widget_disable_begin" 'function)) :void
  (ctx :pointer))

(cffi:defcfun ("nk_widget_disable_end" #.(swig-lispify "widget_disable_end" 'function)) :void
  (ctx :pointer))

(cffi:defcfun ("nk_text" #.(swig-lispify "text" 'function)) :void
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (arg3 :unsigned-int))

(cffi:defcfun ("nk_text_colored" #.(swig-lispify "text_colored" 'function)) :void
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (arg3 :unsigned-int)
  (arg4 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_text_wrap" #.(swig-lispify "text_wrap" 'function)) :void
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int))

(cffi:defcfun ("nk_text_wrap_colored" #.(swig-lispify "text_wrap_colored" 'function)) :void
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_label" #.(swig-lispify "label" 'function)) :void
  (arg0 :pointer)
  (arg1 :string)
  (align :unsigned-int))

(cffi:defcfun ("nk_label_colored" #.(swig-lispify "label_colored" 'function)) :void
  (arg0 :pointer)
  (arg1 :string)
  (align :unsigned-int)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_label_wrap" #.(swig-lispify "label_wrap" 'function)) :void
  (arg0 :pointer)
  (arg1 :string))

(cffi:defcfun ("nk_label_colored_wrap" #.(swig-lispify "label_colored_wrap" 'function)) :void
  (arg0 :pointer)
  (arg1 :string)
  (arg2 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_image_color" #.(swig-lispify "image_color" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_button_text" #.(swig-lispify "button_text" 'function)) :int
  (arg0 :pointer)
  (title :string)
  (len :int))

(cffi:defcfun ("nk_button_label" #.(swig-lispify "button_label" 'function)) :int
  (arg0 :pointer)
  (title :string))

(cffi:defcfun ("nk_button_color" #.(swig-lispify "button_color" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_button_symbol" #.(swig-lispify "button_symbol" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname)))

(cffi:defcfun ("nk_button_image" #.(swig-lispify "button_image" 'function)) :int
  (arg0 :pointer)
  (img (:struct #.(swig-lispify "image" 'classname))))

(cffi:defcfun ("nk_button_symbol_label" #.(swig-lispify "button_symbol_label" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_button_symbol_text" #.(swig-lispify "button_symbol_text" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (arg3 :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_button_image_label" #.(swig-lispify "button_image_label" 'function)) :int
  (arg0 :pointer)
  (img (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_button_image_text" #.(swig-lispify "button_image_text" 'function)) :int
  (arg0 :pointer)
  (img (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (arg3 :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_button_text_styled" #.(swig-lispify "button_text_styled" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (title :string)
  (len :int))

(cffi:defcfun ("nk_button_label_styled" #.(swig-lispify "button_label_styled" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (title :string))

(cffi:defcfun ("nk_button_symbol_styled" #.(swig-lispify "button_symbol_styled" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 #.(swig-lispify "symbol_type" 'enumname)))

(cffi:defcfun ("nk_button_image_styled" #.(swig-lispify "button_image_styled" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (img (:struct #.(swig-lispify "image" 'classname))))

(cffi:defcfun ("nk_button_symbol_text_styled" #.(swig-lispify "button_symbol_text_styled" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 #.(swig-lispify "symbol_type" 'enumname))
  (arg3 :string)
  (arg4 :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_button_symbol_label_styled" #.(swig-lispify "button_symbol_label_styled" 'function)) :int
  (ctx :pointer)
  (style :pointer)
  (symbol #.(swig-lispify "symbol_type" 'enumname))
  (title :string)
  (align :unsigned-int))

(cffi:defcfun ("nk_button_image_label_styled" #.(swig-lispify "button_image_label_styled" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (img (:struct #.(swig-lispify "image" 'classname)))
  (arg3 :string)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_button_image_text_styled" #.(swig-lispify "button_image_text_styled" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (img (:struct #.(swig-lispify "image" 'classname)))
  (arg3 :string)
  (arg4 :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_button_set_behavior" #.(swig-lispify "button_set_behavior" 'function)) :void
  (arg0 :pointer)
  (arg1 #.(swig-lispify "button_behavior" 'enumname)))

(cffi:defcfun ("nk_button_push_behavior" #.(swig-lispify "button_push_behavior" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "button_behavior" 'enumname)))

(cffi:defcfun ("nk_button_pop_behavior" #.(swig-lispify "button_pop_behavior" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_check_label" #.(swig-lispify "check_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (active :int))

(cffi:defcfun ("nk_check_text" #.(swig-lispify "check_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (active :int))

(cffi:defcfun ("nk_check_text_align" #.(swig-lispify "check_text_align" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (active :int)
  (widget_alignment :unsigned-int)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_check_flags_label" #.(swig-lispify "check_flags_label" 'function)) :unsigned-int
  (arg0 :pointer)
  (arg1 :string)
  (flags :unsigned-int)
  (value :unsigned-int))

(cffi:defcfun ("nk_check_flags_text" #.(swig-lispify "check_flags_text" 'function)) :unsigned-int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (flags :unsigned-int)
  (value :unsigned-int))

(cffi:defcfun ("nk_checkbox_label" #.(swig-lispify "checkbox_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (active :pointer))

(cffi:defcfun ("nk_checkbox_label_align" #.(swig-lispify "checkbox_label_align" 'function)) :int
  (ctx :pointer)
  (label :string)
  (active :pointer)
  (widget_alignment :unsigned-int)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_checkbox_text" #.(swig-lispify "checkbox_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (active :pointer))

(cffi:defcfun ("nk_checkbox_text_align" #.(swig-lispify "checkbox_text_align" 'function)) :int
  (ctx :pointer)
  (text :string)
  (len :int)
  (active :pointer)
  (widget_alignment :unsigned-int)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_checkbox_flags_label" #.(swig-lispify "checkbox_flags_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (flags :pointer)
  (value :unsigned-int))

(cffi:defcfun ("nk_checkbox_flags_text" #.(swig-lispify "checkbox_flags_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (flags :pointer)
  (value :unsigned-int))

(cffi:defcfun ("nk_radio_label" #.(swig-lispify "radio_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (active :pointer))

(cffi:defcfun ("nk_radio_label_align" #.(swig-lispify "radio_label_align" 'function)) :int
  (ctx :pointer)
  (label :string)
  (active :pointer)
  (widget_alignment :unsigned-int)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_radio_text" #.(swig-lispify "radio_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (active :pointer))

(cffi:defcfun ("nk_radio_text_align" #.(swig-lispify "radio_text_align" 'function)) :int
  (ctx :pointer)
  (text :string)
  (len :int)
  (active :pointer)
  (widget_alignment :unsigned-int)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_option_label" #.(swig-lispify "option_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (active :int))

(cffi:defcfun ("nk_option_label_align" #.(swig-lispify "option_label_align" 'function)) :int
  (ctx :pointer)
  (label :string)
  (active :int)
  (widget_alignment :unsigned-int)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_option_text" #.(swig-lispify "option_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (active :int))

(cffi:defcfun ("nk_option_text_align" #.(swig-lispify "option_text_align" 'function)) :int
  (ctx :pointer)
  (text :string)
  (len :int)
  (is_active :int)
  (widget_alignment :unsigned-int)
  (text_alignment :unsigned-int))

(cffi:defcfun ("nk_selectable_label" #.(swig-lispify "selectable_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (align :unsigned-int)
  (value :pointer))

(cffi:defcfun ("nk_selectable_text" #.(swig-lispify "selectable_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (align :unsigned-int)
  (value :pointer))

(cffi:defcfun ("nk_selectable_image_label" #.(swig-lispify "selectable_image_label" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (align :unsigned-int)
  (value :pointer))

(cffi:defcfun ("nk_selectable_image_text" #.(swig-lispify "selectable_image_text" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (arg3 :int)
  (align :unsigned-int)
  (value :pointer))

(cffi:defcfun ("nk_selectable_symbol_label" #.(swig-lispify "selectable_symbol_label" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (align :unsigned-int)
  (value :pointer))

(cffi:defcfun ("nk_selectable_symbol_text" #.(swig-lispify "selectable_symbol_text" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (arg3 :int)
  (align :unsigned-int)
  (value :pointer))

(cffi:defcfun ("nk_select_label" #.(swig-lispify "select_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (align :unsigned-int)
  (value :int))

(cffi:defcfun ("nk_select_text" #.(swig-lispify "select_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (align :unsigned-int)
  (value :int))

(cffi:defcfun ("nk_select_image_label" #.(swig-lispify "select_image_label" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (align :unsigned-int)
  (value :int))

(cffi:defcfun ("nk_select_image_text" #.(swig-lispify "select_image_text" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (arg3 :int)
  (align :unsigned-int)
  (value :int))

(cffi:defcfun ("nk_select_symbol_label" #.(swig-lispify "select_symbol_label" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (align :unsigned-int)
  (value :int))

(cffi:defcfun ("nk_select_symbol_text" #.(swig-lispify "select_symbol_text" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (arg3 :int)
  (align :unsigned-int)
  (value :int))

(cffi:defcfun ("nk_slide_float" #.(swig-lispify "slide_float" 'function)) :float
  (arg0 :pointer)
  (min :float)
  (val :float)
  (max :float)
  (step :float))

(cffi:defcfun ("nk_slide_int" #.(swig-lispify "slide_int" 'function)) :int
  (arg0 :pointer)
  (min :int)
  (val :int)
  (max :int)
  (step :int))

(cffi:defcfun ("nk_slider_float" #.(swig-lispify "slider_float" 'function)) :int
  (arg0 :pointer)
  (min :float)
  (val :pointer)
  (max :float)
  (step :float))

(cffi:defcfun ("nk_slider_int" #.(swig-lispify "slider_int" 'function)) :int
  (arg0 :pointer)
  (min :int)
  (val :pointer)
  (max :int)
  (step :int))

(cffi:defcfun ("nk_knob_float" #.(swig-lispify "knob_float" 'function)) :pointer
  (arg0 :pointer)
  (min :float)
  (val :pointer)
  (max :float)
  (step :float)
  (zero_direction #.(swig-lispify "heading" 'enumname))
  (dead_zone_degrees :float))

(cffi:defcfun ("nk_knob_int" #.(swig-lispify "knob_int" 'function)) :pointer
  (arg0 :pointer)
  (min :int)
  (val :pointer)
  (max :int)
  (step :int)
  (zero_direction #.(swig-lispify "heading" 'enumname))
  (dead_zone_degrees :float))

(cffi:defcfun ("nk_progress" #.(swig-lispify "progress" 'function)) :int
  (arg0 :pointer)
  (cur :pointer)
  (max :unsigned-long)
  (modifyable :int))

(cffi:defcfun ("nk_prog" #.(swig-lispify "prog_" 'function)) :unsigned-long
  (arg0 :pointer)
  (cur :unsigned-long)
  (max :unsigned-long)
  (modifyable :int))

(cffi:defcfun ("nk_color_picker" #.(swig-lispify "color_picker" 'function)) (:struct #.(swig-lispify "colorf" 'classname))
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "colorf" 'classname)))
  (arg2 #.(swig-lispify "color_format" 'enumname)))

(cffi:defcfun ("nk_color_pick" #.(swig-lispify "color_pick" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 #.(swig-lispify "color_format" 'enumname)))

(cffi:defcfun ("nk_property_int" #.(swig-lispify "property_int" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (min :int)
  (val :pointer)
  (max :int)
  (step :int)
  (inc_per_pixel :float))

(cffi:defcfun ("nk_property_float" #.(swig-lispify "property_float" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (min :float)
  (val :pointer)
  (max :float)
  (step :float)
  (inc_per_pixel :float))

(cffi:defcfun ("nk_property_double" #.(swig-lispify "property_double" 'function)) :void
  (arg0 :pointer)
  (name :string)
  (min :double)
  (val :pointer)
  (max :double)
  (step :double)
  (inc_per_pixel :float))

(cffi:defcfun ("nk_propertyi" #.(swig-lispify "propertyi" 'function)) :int
  (arg0 :pointer)
  (name :string)
  (min :int)
  (val :int)
  (max :int)
  (step :int)
  (inc_per_pixel :float))

(cffi:defcfun ("nk_propertyf" #.(swig-lispify "propertyf" 'function)) :float
  (arg0 :pointer)
  (name :string)
  (min :float)
  (val :float)
  (max :float)
  (step :float)
  (inc_per_pixel :float))

(cffi:defcfun ("nk_propertyd" #.(swig-lispify "propertyd" 'function)) :double
  (arg0 :pointer)
  (name :string)
  (min :double)
  (val :double)
  (max :double)
  (step :double)
  (inc_per_pixel :float))

(cffi:defcfun ("nk_edit_string" #.(swig-lispify "edit_string" 'function)) :unsigned-int
  (arg0 :pointer)
  (arg1 :unsigned-int)
  (buffer :string)
  (len :pointer)
  (max :int)
  (arg5 :pointer))

(cffi:defcfun ("nk_edit_string_zero_terminated" #.(swig-lispify "edit_string_zero_terminated" 'function)) :unsigned-int
  (arg0 :pointer)
  (arg1 :unsigned-int)
  (buffer :string)
  (max :int)
  (arg4 :pointer))

(cffi:defcfun ("nk_edit_buffer" #.(swig-lispify "edit_buffer" 'function)) :unsigned-int
  (arg0 :pointer)
  (arg1 :unsigned-int)
  (arg2 :pointer)
  (arg3 :pointer))

(cffi:defcfun ("nk_edit_focus" #.(swig-lispify "edit_focus" 'function)) :void
  (arg0 :pointer)
  (flags :unsigned-int))

(cffi:defcfun ("nk_edit_unfocus" #.(swig-lispify "edit_unfocus" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_chart_begin" #.(swig-lispify "chart_begin" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "chart_type" 'enumname))
  (num :int)
  (min :float)
  (max :float))

(cffi:defcfun ("nk_chart_begin_colored" #.(swig-lispify "chart_begin_colored" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "chart_type" 'enumname))
  (arg2 (:struct #.(swig-lispify "color" 'classname)))
  (active (:struct #.(swig-lispify "color" 'classname)))
  (num :int)
  (min :float)
  (max :float))

(cffi:defcfun ("nk_chart_add_slot" #.(swig-lispify "chart_add_slot" 'function)) :void
  (ctx :pointer)
  (arg1 #.(swig-lispify "chart_type" 'enumname))
  (count :int)
  (min_value :float)
  (max_value :float))

(cffi:defcfun ("nk_chart_add_slot_colored" #.(swig-lispify "chart_add_slot_colored" 'function)) :void
  (ctx :pointer)
  (arg1 #.(swig-lispify "chart_type" 'enumname))
  (arg2 (:struct #.(swig-lispify "color" 'classname)))
  (active (:struct #.(swig-lispify "color" 'classname)))
  (count :int)
  (min_value :float)
  (max_value :float))

(cffi:defcfun ("nk_chart_push" #.(swig-lispify "chart_push" 'function)) :unsigned-int
  (arg0 :pointer)
  (arg1 :float))

(cffi:defcfun ("nk_chart_push_slot" #.(swig-lispify "chart_push_slot" 'function)) :unsigned-int
  (arg0 :pointer)
  (arg1 :float)
  (arg2 :int))

(cffi:defcfun ("nk_chart_end" #.(swig-lispify "chart_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_plot" #.(swig-lispify "plot" 'function)) :void
  (arg0 :pointer)
  (arg1 #.(swig-lispify "chart_type" 'enumname))
  (values :pointer)
  (count :int)
  (offset :int))

(cffi:defcfun ("nk_plot_function" #.(swig-lispify "plot_function" 'function)) :void
  (arg0 :pointer)
  (arg1 #.(swig-lispify "chart_type" 'enumname))
  (userdata :pointer)
  (value_getter :pointer)
  (count :int)
  (offset :int))

(cffi:defcfun ("nk_popup_begin" #.(swig-lispify "popup_begin" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "popup_type" 'enumname))
  (arg2 :string)
  (arg3 :unsigned-int)
  (bounds (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_popup_close" #.(swig-lispify "popup_close" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_popup_end" #.(swig-lispify "popup_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_popup_get_scroll" #.(swig-lispify "popup_get_scroll" 'function)) :void
  (arg0 :pointer)
  (offset_x :pointer)
  (offset_y :pointer))

(cffi:defcfun ("nk_popup_set_scroll" #.(swig-lispify "popup_set_scroll" 'function)) :void
  (arg0 :pointer)
  (offset_x :unsigned-int)
  (offset_y :unsigned-int))

(cffi:defcfun ("nk_combo" #.(swig-lispify "combo" 'function)) :int
  (arg0 :pointer)
  (items :pointer)
  (count :int)
  (selected :int)
  (item_height :int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_separator" #.(swig-lispify "combo_separator" 'function)) :int
  (arg0 :pointer)
  (items_separated_by_separator :string)
  (separator :int)
  (selected :int)
  (count :int)
  (item_height :int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_string" #.(swig-lispify "combo_string" 'function)) :int
  (arg0 :pointer)
  (items_separated_by_zeros :string)
  (selected :int)
  (count :int)
  (item_height :int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_callback" #.(swig-lispify "combo_callback" 'function)) :int
  (arg0 :pointer)
  (item_getter :pointer)
  (userdata :pointer)
  (selected :int)
  (count :int)
  (item_height :int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combobox" #.(swig-lispify "combobox" 'function)) :void
  (arg0 :pointer)
  (items :pointer)
  (count :int)
  (selected :pointer)
  (item_height :int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combobox_string" #.(swig-lispify "combobox_string" 'function)) :void
  (arg0 :pointer)
  (items_separated_by_zeros :string)
  (selected :pointer)
  (count :int)
  (item_height :int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combobox_separator" #.(swig-lispify "combobox_separator" 'function)) :void
  (arg0 :pointer)
  (items_separated_by_separator :string)
  (separator :int)
  (selected :pointer)
  (count :int)
  (item_height :int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combobox_callback" #.(swig-lispify "combobox_callback" 'function)) :void
  (arg0 :pointer)
  (item_getter :pointer)
  (arg2 :pointer)
  (selected :pointer)
  (count :int)
  (item_height :int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_begin_text" #.(swig-lispify "combo_begin_text" 'function)) :int
  (arg0 :pointer)
  (selected :string)
  (arg2 :int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_begin_label" #.(swig-lispify "combo_begin_label" 'function)) :int
  (arg0 :pointer)
  (selected :string)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_begin_color" #.(swig-lispify "combo_begin_color" 'function)) :int
  (arg0 :pointer)
  (color (:struct #.(swig-lispify "color" 'classname)))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_begin_symbol" #.(swig-lispify "combo_begin_symbol" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_begin_symbol_label" #.(swig-lispify "combo_begin_symbol_label" 'function)) :int
  (arg0 :pointer)
  (selected :string)
  (arg2 #.(swig-lispify "symbol_type" 'enumname))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_begin_symbol_text" #.(swig-lispify "combo_begin_symbol_text" 'function)) :int
  (arg0 :pointer)
  (selected :string)
  (arg2 :int)
  (arg3 #.(swig-lispify "symbol_type" 'enumname))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_begin_image" #.(swig-lispify "combo_begin_image" 'function)) :int
  (arg0 :pointer)
  (img (:struct #.(swig-lispify "image" 'classname)))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_begin_image_label" #.(swig-lispify "combo_begin_image_label" 'function)) :int
  (arg0 :pointer)
  (selected :string)
  (arg2 (:struct #.(swig-lispify "image" 'classname)))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_begin_image_text" #.(swig-lispify "combo_begin_image_text" 'function)) :int
  (arg0 :pointer)
  (selected :string)
  (arg2 :int)
  (arg3 (:struct #.(swig-lispify "image" 'classname)))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_combo_item_label" #.(swig-lispify "combo_item_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_combo_item_text" #.(swig-lispify "combo_item_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_combo_item_image_label" #.(swig-lispify "combo_item_image_label" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_combo_item_image_text" #.(swig-lispify "combo_item_image_text" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (arg3 :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_combo_item_symbol_label" #.(swig-lispify "combo_item_symbol_label" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_combo_item_symbol_text" #.(swig-lispify "combo_item_symbol_text" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (arg3 :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_combo_close" #.(swig-lispify "combo_close" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_combo_end" #.(swig-lispify "combo_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_contextual_begin" #.(swig-lispify "contextual_begin" 'function)) :int
  (arg0 :pointer)
  (arg1 :unsigned-int)
  (arg2 (:struct #.(swig-lispify "vec2" 'classname)))
  (trigger_bounds (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_contextual_item_text" #.(swig-lispify "contextual_item_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (align :unsigned-int))

(cffi:defcfun ("nk_contextual_item_label" #.(swig-lispify "contextual_item_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (align :unsigned-int))

(cffi:defcfun ("nk_contextual_item_image_label" #.(swig-lispify "contextual_item_image_label" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_contextual_item_image_text" #.(swig-lispify "contextual_item_image_text" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (len :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_contextual_item_symbol_label" #.(swig-lispify "contextual_item_symbol_label" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_contextual_item_symbol_text" #.(swig-lispify "contextual_item_symbol_text" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (arg3 :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_contextual_close" #.(swig-lispify "contextual_close" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_contextual_end" #.(swig-lispify "contextual_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_tooltip" #.(swig-lispify "tooltip" 'function)) :void
  (arg0 :pointer)
  (arg1 :string))

(cffi:defcfun ("nk_tooltip_begin" #.(swig-lispify "tooltip_begin" 'function)) :int
  (arg0 :pointer)
  (width :float))

(cffi:defcfun ("nk_tooltip_end" #.(swig-lispify "tooltip_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_menubar_begin" #.(swig-lispify "menubar_begin" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_menubar_end" #.(swig-lispify "menubar_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_menu_begin_text" #.(swig-lispify "menu_begin_text" 'function)) :int
  (arg0 :pointer)
  (title :string)
  (title_len :int)
  (align :unsigned-int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_menu_begin_label" #.(swig-lispify "menu_begin_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (align :unsigned-int)
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_menu_begin_image" #.(swig-lispify "menu_begin_image" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 (:struct #.(swig-lispify "image" 'classname)))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_menu_begin_image_text" #.(swig-lispify "menu_begin_image_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (align :unsigned-int)
  (arg4 (:struct #.(swig-lispify "image" 'classname)))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_menu_begin_image_label" #.(swig-lispify "menu_begin_image_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (align :unsigned-int)
  (arg3 (:struct #.(swig-lispify "image" 'classname)))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_menu_begin_symbol" #.(swig-lispify "menu_begin_symbol" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 #.(swig-lispify "symbol_type" 'enumname))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_menu_begin_symbol_text" #.(swig-lispify "menu_begin_symbol_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (align :unsigned-int)
  (arg4 #.(swig-lispify "symbol_type" 'enumname))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_menu_begin_symbol_label" #.(swig-lispify "menu_begin_symbol_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (align :unsigned-int)
  (arg3 #.(swig-lispify "symbol_type" 'enumname))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_menu_item_text" #.(swig-lispify "menu_item_text" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (arg2 :int)
  (align :unsigned-int))

(cffi:defcfun ("nk_menu_item_label" #.(swig-lispify "menu_item_label" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_menu_item_image_label" #.(swig-lispify "menu_item_image_label" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_menu_item_image_text" #.(swig-lispify "menu_item_image_text" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "image" 'classname)))
  (arg2 :string)
  (len :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_menu_item_symbol_text" #.(swig-lispify "menu_item_symbol_text" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (arg3 :int)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_menu_item_symbol_label" #.(swig-lispify "menu_item_symbol_label" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "symbol_type" 'enumname))
  (arg2 :string)
  (alignment :unsigned-int))

(cffi:defcfun ("nk_menu_close" #.(swig-lispify "menu_close" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_menu_end" #.(swig-lispify "menu_end" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_style_default" #.(swig-lispify "style_default" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_style_from_table" #.(swig-lispify "style_from_table" 'function)) :void
  (arg0 :pointer)
  (arg1 :pointer))

(cffi:defcfun ("nk_style_load_cursor" #.(swig-lispify "style_load_cursor" 'function)) :void
  (arg0 :pointer)
  (arg1 #.(swig-lispify "style_cursor" 'enumname))
  (arg2 :pointer))

(cffi:defcfun ("nk_style_load_all_cursors" #.(swig-lispify "style_load_all_cursors" 'function)) :void
  (arg0 :pointer)
  (arg1 :pointer))

(cffi:defcfun ("nk_style_get_color_by_name" #.(swig-lispify "style_get_color_by_name" 'function)) :string
  (arg0 #.(swig-lispify "style_colors" 'enumname)))

(cffi:defcfun ("nk_style_set_font" #.(swig-lispify "style_set_font" 'function)) :void
  (arg0 :pointer)
  (arg1 :pointer))

(cffi:defcfun ("nk_style_set_cursor" #.(swig-lispify "style_set_cursor" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "style_cursor" 'enumname)))

(cffi:defcfun ("nk_style_show_cursor" #.(swig-lispify "style_show_cursor" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_style_hide_cursor" #.(swig-lispify "style_hide_cursor" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_style_push_font" #.(swig-lispify "style_push_font" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer))

(cffi:defcfun ("nk_style_push_float" #.(swig-lispify "style_push_float" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 :float))

(cffi:defcfun ("nk_style_push_vec2" #.(swig-lispify "style_push_vec2" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_style_push_style_item" #.(swig-lispify "style_push_style_item" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 (:struct #.(swig-lispify "style_item" 'classname))))

(cffi:defcfun ("nk_style_push_flags" #.(swig-lispify "style_push_flags" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 :unsigned-int))

(cffi:defcfun ("nk_style_push_color" #.(swig-lispify "style_push_color" 'function)) :int
  (arg0 :pointer)
  (arg1 :pointer)
  (arg2 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_style_pop_font" #.(swig-lispify "style_pop_font" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_style_pop_float" #.(swig-lispify "style_pop_float" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_style_pop_vec2" #.(swig-lispify "style_pop_vec2" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_style_pop_style_item" #.(swig-lispify "style_pop_style_item" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_style_pop_flags" #.(swig-lispify "style_pop_flags" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_style_pop_color" #.(swig-lispify "style_pop_color" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_rgb" #.(swig-lispify "rgb" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (r :int)
  (g :int)
  (b :int))

(cffi:defcfun ("nk_rgb_iv" #.(swig-lispify "rgb_iv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (rgb :pointer))

(cffi:defcfun ("nk_rgb_bv" #.(swig-lispify "rgb_bv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (rgb :pointer))

(cffi:defcfun ("nk_rgb_f" #.(swig-lispify "rgb_f" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (r :float)
  (g :float)
  (b :float))

(cffi:defcfun ("nk_rgb_fv" #.(swig-lispify "rgb_fv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (rgb :pointer))

(cffi:defcfun ("nk_rgb_cf" #.(swig-lispify "rgb_cf" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (c (:struct #.(swig-lispify "colorf" 'classname))))

(cffi:defcfun ("nk_rgb_hex" #.(swig-lispify "rgb_hex" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (rgb :string))

(cffi:defcfun ("nk_rgb_factor" #.(swig-lispify "rgb_factor" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (col (:struct #.(swig-lispify "color" 'classname)))
  (factor :float))

(cffi:defcfun ("nk_rgba" #.(swig-lispify "rgba" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (r :int)
  (g :int)
  (b :int)
  (a :int))

(cffi:defcfun ("nk_rgba_u32" #.(swig-lispify "rgba_u32" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (arg0 :unsigned-int))

(cffi:defcfun ("nk_rgba_iv" #.(swig-lispify "rgba_iv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (rgba :pointer))

(cffi:defcfun ("nk_rgba_bv" #.(swig-lispify "rgba_bv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (rgba :pointer))

(cffi:defcfun ("nk_rgba_f" #.(swig-lispify "rgba_f" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (r :float)
  (g :float)
  (b :float)
  (a :float))

(cffi:defcfun ("nk_rgba_fv" #.(swig-lispify "rgba_fv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (rgba :pointer))

(cffi:defcfun ("nk_rgba_cf" #.(swig-lispify "rgba_cf" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (c (:struct #.(swig-lispify "colorf" 'classname))))

(cffi:defcfun ("nk_rgba_hex" #.(swig-lispify "rgba_hex" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (rgb :string))

(cffi:defcfun ("nk_hsva_colorf" #.(swig-lispify "hsva_colorf" 'function)) (:struct #.(swig-lispify "colorf" 'classname))
  (h :float)
  (s :float)
  (v :float)
  (a :float))

(cffi:defcfun ("nk_hsva_colorfv" #.(swig-lispify "hsva_colorfv" 'function)) (:struct #.(swig-lispify "colorf" 'classname))
  (c :pointer))

(cffi:defcfun ("nk_colorf_hsva_f" #.(swig-lispify "colorf_hsva_f" 'function)) :void
  (out_h :pointer)
  (out_s :pointer)
  (out_v :pointer)
  (out_a :pointer)
  (in (:struct #.(swig-lispify "colorf" 'classname))))

(cffi:defcfun ("nk_colorf_hsva_fv" #.(swig-lispify "colorf_hsva_fv" 'function)) :void
  (hsva :pointer)
  (in (:struct #.(swig-lispify "colorf" 'classname))))

(cffi:defcfun ("nk_hsv" #.(swig-lispify "hsv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (h :int)
  (s :int)
  (v :int))

(cffi:defcfun ("nk_hsv_iv" #.(swig-lispify "hsv_iv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (hsv :pointer))

(cffi:defcfun ("nk_hsv_bv" #.(swig-lispify "hsv_bv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (hsv :pointer))

(cffi:defcfun ("nk_hsv_f" #.(swig-lispify "hsv_f" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (h :float)
  (s :float)
  (v :float))

(cffi:defcfun ("nk_hsv_fv" #.(swig-lispify "hsv_fv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (hsv :pointer))

(cffi:defcfun ("nk_hsva" #.(swig-lispify "hsva" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (h :int)
  (s :int)
  (v :int)
  (a :int))

(cffi:defcfun ("nk_hsva_iv" #.(swig-lispify "hsva_iv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (hsva :pointer))

(cffi:defcfun ("nk_hsva_bv" #.(swig-lispify "hsva_bv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (hsva :pointer))

(cffi:defcfun ("nk_hsva_f" #.(swig-lispify "hsva_f" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (h :float)
  (s :float)
  (v :float)
  (a :float))

(cffi:defcfun ("nk_hsva_fv" #.(swig-lispify "hsva_fv" 'function)) (:struct #.(swig-lispify "color" 'classname))
  (hsva :pointer))

(cffi:defcfun ("nk_color_f" #.(swig-lispify "color_f" 'function)) :void
  (r :pointer)
  (g :pointer)
  (b :pointer)
  (a :pointer)
  (arg4 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_fv" #.(swig-lispify "color_fv" 'function)) :void
  (rgba_out :pointer)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_cf" #.(swig-lispify "color_cf" 'function)) (:struct #.(swig-lispify "colorf" 'classname))
  (arg0 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_d" #.(swig-lispify "color_d" 'function)) :void
  (r :pointer)
  (g :pointer)
  (b :pointer)
  (a :pointer)
  (arg4 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_dv" #.(swig-lispify "color_dv" 'function)) :void
  (rgba_out :pointer)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_u32" #.(swig-lispify "color_u32" 'function)) :unsigned-int
  (arg0 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hex_rgba" #.(swig-lispify "color_hex_rgba" 'function)) :void
  (output :string)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hex_rgb" #.(swig-lispify "color_hex_rgb" 'function)) :void
  (output :string)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsv_i" #.(swig-lispify "color_hsv_i" 'function)) :void
  (out_h :pointer)
  (out_s :pointer)
  (out_v :pointer)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsv_b" #.(swig-lispify "color_hsv_b" 'function)) :void
  (out_h :pointer)
  (out_s :pointer)
  (out_v :pointer)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsv_iv" #.(swig-lispify "color_hsv_iv" 'function)) :void
  (hsv_out :pointer)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsv_bv" #.(swig-lispify "color_hsv_bv" 'function)) :void
  (hsv_out :pointer)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsv_f" #.(swig-lispify "color_hsv_f" 'function)) :void
  (out_h :pointer)
  (out_s :pointer)
  (out_v :pointer)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsv_fv" #.(swig-lispify "color_hsv_fv" 'function)) :void
  (hsv_out :pointer)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsva_i" #.(swig-lispify "color_hsva_i" 'function)) :void
  (h :pointer)
  (s :pointer)
  (v :pointer)
  (a :pointer)
  (arg4 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsva_b" #.(swig-lispify "color_hsva_b" 'function)) :void
  (h :pointer)
  (s :pointer)
  (v :pointer)
  (a :pointer)
  (arg4 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsva_iv" #.(swig-lispify "color_hsva_iv" 'function)) :void
  (hsva_out :pointer)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsva_bv" #.(swig-lispify "color_hsva_bv" 'function)) :void
  (hsva_out :pointer)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsva_f" #.(swig-lispify "color_hsva_f" 'function)) :void
  (out_h :pointer)
  (out_s :pointer)
  (out_v :pointer)
  (out_a :pointer)
  (arg4 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_color_hsva_fv" #.(swig-lispify "color_hsva_fv" 'function)) :void
  (hsva_out :pointer)
  (arg1 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_handle_ptr" #.(swig-lispify "handle_ptr" 'function)) :pointer
  (arg0 :pointer))

(cffi:defcfun ("nk_handle_id" #.(swig-lispify "handle_id" 'function)) :pointer
  (arg0 :int))

(cffi:defcfun ("nk_image_handle" #.(swig-lispify "image_handle" 'function)) (:struct #.(swig-lispify "image" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_image_ptr" #.(swig-lispify "image_ptr" 'function)) (:struct #.(swig-lispify "image" 'classname))
  (arg0 :pointer))

(cffi:defcfun ("nk_image_id" #.(swig-lispify "image_id" 'function)) (:struct #.(swig-lispify "image" 'classname))
  (arg0 :int))

(cffi:defcfun ("nk_image_is_subimage" #.(swig-lispify "image_is_subimage" 'function)) :int
  (img :pointer))

(cffi:defcfun ("nk_subimage_ptr" #.(swig-lispify "subimage_ptr" 'function)) (:struct #.(swig-lispify "image" 'classname))
  (arg0 :pointer)
  (w :unsigned-short)
  (h :unsigned-short)
  (sub_region (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_subimage_id" #.(swig-lispify "subimage_id" 'function)) (:struct #.(swig-lispify "image" 'classname))
  (arg0 :int)
  (w :unsigned-short)
  (h :unsigned-short)
  (sub_region (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_subimage_handle" #.(swig-lispify "subimage_handle" 'function)) (:struct #.(swig-lispify "image" 'classname))
  (arg0 :pointer)
  (w :unsigned-short)
  (h :unsigned-short)
  (sub_region (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_nine_slice_handle" #.(swig-lispify "nine_slice_handle" 'function)) (:struct #.(swig-lispify "nine_slice" 'classname))
  (arg0 :pointer)
  (l :unsigned-short)
  (t_arg2 :unsigned-short)
  (r :unsigned-short)
  (b :unsigned-short))

(cffi:defcfun ("nk_nine_slice_ptr" #.(swig-lispify "nine_slice_ptr" 'function)) (:struct #.(swig-lispify "nine_slice" 'classname))
  (arg0 :pointer)
  (l :unsigned-short)
  (t_arg2 :unsigned-short)
  (r :unsigned-short)
  (b :unsigned-short))

(cffi:defcfun ("nk_nine_slice_id" #.(swig-lispify "nine_slice_id" 'function)) (:struct #.(swig-lispify "nine_slice" 'classname))
  (arg0 :int)
  (l :unsigned-short)
  (t_arg2 :unsigned-short)
  (r :unsigned-short)
  (b :unsigned-short))

(cffi:defcfun ("nk_nine_slice_is_sub9slice" #.(swig-lispify "nine_slice_is_sub9slice" 'function)) :int
  (img :pointer))

(cffi:defcfun ("nk_sub9slice_ptr" #.(swig-lispify "sub9slice_ptr" 'function)) (:struct #.(swig-lispify "nine_slice" 'classname))
  (arg0 :pointer)
  (w :unsigned-short)
  (h :unsigned-short)
  (sub_region (:struct #.(swig-lispify "rect" 'classname)))
  (l :unsigned-short)
  (t_arg5 :unsigned-short)
  (r :unsigned-short)
  (b :unsigned-short))

(cffi:defcfun ("nk_sub9slice_id" #.(swig-lispify "sub9slice_id" 'function)) (:struct #.(swig-lispify "nine_slice" 'classname))
  (arg0 :int)
  (w :unsigned-short)
  (h :unsigned-short)
  (sub_region (:struct #.(swig-lispify "rect" 'classname)))
  (l :unsigned-short)
  (t_arg5 :unsigned-short)
  (r :unsigned-short)
  (b :unsigned-short))

(cffi:defcfun ("nk_sub9slice_handle" #.(swig-lispify "sub9slice_handle" 'function)) (:struct #.(swig-lispify "nine_slice" 'classname))
  (arg0 :pointer)
  (w :unsigned-short)
  (h :unsigned-short)
  (sub_region (:struct #.(swig-lispify "rect" 'classname)))
  (l :unsigned-short)
  (t_arg5 :unsigned-short)
  (r :unsigned-short)
  (b :unsigned-short))

(cffi:defcfun ("nk_murmur_hash" #.(swig-lispify "murmur_hash" 'function)) :unsigned-int
  (key :pointer)
  (len :int)
  (seed :unsigned-int))

(cffi:defcfun ("nk_triangle_from_direction" #.(swig-lispify "triangle_from_direction" 'function)) :void
  (result :pointer)
  (r (:struct #.(swig-lispify "rect" 'classname)))
  (pad_x :float)
  (pad_y :float)
  (arg4 #.(swig-lispify "heading" 'enumname)))

(cffi:defcfun ("nk_vec2i" #.(swig-lispify "vec2i" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (x :int)
  (y :int))

(cffi:defcfun ("nk_vec2v" #.(swig-lispify "vec2v" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (xy :pointer))

(cffi:defcfun ("nk_vec2iv" #.(swig-lispify "vec2iv" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (xy :pointer))

(cffi:defcfun ("nk_get_null_rect" #.(swig-lispify "get_null_rect" 'function)) (:struct #.(swig-lispify "rect" 'classname)))

(cffi:defcfun ("nk_recti" #.(swig-lispify "recti" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (x :int)
  (y :int)
  (w :int)
  (h :int))

(cffi:defcfun ("nk_recta" #.(swig-lispify "recta" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (pos (:struct #.(swig-lispify "vec2" 'classname)))
  (size (:struct #.(swig-lispify "vec2" 'classname))))

(cffi:defcfun ("nk_rectv" #.(swig-lispify "rectv" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (xywh :pointer))

(cffi:defcfun ("nk_rectiv" #.(swig-lispify "rectiv" 'function)) (:struct #.(swig-lispify "rect" 'classname))
  (xywh :pointer))

(cffi:defcfun ("nk_rect_pos" #.(swig-lispify "rect_pos" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_rect_size" #.(swig-lispify "rect_size" 'function)) (:struct #.(swig-lispify "vec2" 'classname))
  (arg0 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_strfilter" #.(swig-lispify "strfilter" 'function)) :int
  (text :string)
  (regexp :string))

(cffi:defcfun ("nk_strmatch_fuzzy_string" #.(swig-lispify "strmatch_fuzzy_string" 'function)) :int
  (str :string)
  (pattern :string)
  (out_score :pointer))

(cffi:defcfun ("nk_strmatch_fuzzy_text" #.(swig-lispify "strmatch_fuzzy_text" 'function)) :int
  (txt :string)
  (txt_len :int)
  (pattern :string)
  (out_score :pointer))

(cffi:defcfun ("nk_utf_decode" #.(swig-lispify "utf_decode" 'function)) :int
  (arg0 :string)
  (arg1 :pointer)
  (arg2 :int))

(cffi:defcfun ("nk_utf_encode" #.(swig-lispify "utf_encode" 'function)) :int
  (arg0 :unsigned-int)
  (arg1 :string)
  (arg2 :int))

(cffi:defcfun ("nk_utf_len" #.(swig-lispify "utf_len" 'function)) :int
  (arg0 :string)
  (byte_len :int))

(cffi:defcfun ("nk_utf_at" #.(swig-lispify "utf_at" 'function)) :string
  (buffer :string)
  (length :int)
  (index :int)
  (unicode :pointer)
  (len :pointer))

(cffi:defcfun ("nk_filter_default" #.(swig-lispify "filter_default" 'function)) :int
  (arg0 :pointer)
  (unicode :unsigned-int))

(cffi:defcfun ("nk_filter_ascii" #.(swig-lispify "filter_ascii" 'function)) :int
  (arg0 :pointer)
  (unicode :unsigned-int))

(cffi:defcfun ("nk_filter_float" #.(swig-lispify "filter_float" 'function)) :int
  (arg0 :pointer)
  (unicode :unsigned-int))

(cffi:defcfun ("nk_filter_decimal" #.(swig-lispify "filter_decimal" 'function)) :int
  (arg0 :pointer)
  (unicode :unsigned-int))

(cffi:defcfun ("nk_filter_hex" #.(swig-lispify "filter_hex" 'function)) :int
  (arg0 :pointer)
  (unicode :unsigned-int))

(cffi:defcfun ("nk_filter_oct" #.(swig-lispify "filter_oct" 'function)) :int
  (arg0 :pointer)
  (unicode :unsigned-int))

(cffi:defcfun ("nk_filter_binary" #.(swig-lispify "filter_binary" 'function)) :int
  (arg0 :pointer)
  (unicode :unsigned-int))

(cffi:defcfun ("nk_textedit_init_default" #.(swig-lispify "textedit_init_default" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_textedit_init" #.(swig-lispify "textedit_init" 'function)) :void
  (arg0 :pointer)
  (arg1 :pointer)
  (size :unsigned-long))

(cffi:defcfun ("nk_textedit_init_fixed" #.(swig-lispify "textedit_init_fixed" 'function)) :void
  (arg0 :pointer)
  (memory :pointer)
  (size :unsigned-long))

(cffi:defcfun ("nk_textedit_free" #.(swig-lispify "textedit_free" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_textedit_text" #.(swig-lispify "textedit_text" 'function)) :void
  (arg0 :pointer)
  (arg1 :string)
  (total_len :int))

(cffi:defcfun ("nk_textedit_delete" #.(swig-lispify "textedit_delete" 'function)) :void
  (arg0 :pointer)
  (where :int)
  (len :int))

(cffi:defcfun ("nk_textedit_delete_selection" #.(swig-lispify "textedit_delete_selection" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_textedit_select_all" #.(swig-lispify "textedit_select_all" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_textedit_cut" #.(swig-lispify "textedit_cut" 'function)) :int
  (arg0 :pointer))

(cffi:defcfun ("nk_textedit_paste" #.(swig-lispify "textedit_paste" 'function)) :int
  (arg0 :pointer)
  (arg1 :string)
  (len :int))

(cffi:defcfun ("nk_textedit_undo" #.(swig-lispify "textedit_undo" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_textedit_redo" #.(swig-lispify "textedit_redo" 'function)) :void
  (arg0 :pointer))

(cffi:defcfun ("nk_stroke_line" #.(swig-lispify "stroke_line" 'function)) :void
  (b :pointer)
  (x0 :float)
  (y0 :float)
  (x1 :float)
  (y1 :float)
  (line_thickness :float)
  (arg6 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_stroke_curve" #.(swig-lispify "stroke_curve" 'function)) :void
  (arg0 :pointer)
  (arg1 :float)
  (arg2 :float)
  (arg3 :float)
  (arg4 :float)
  (arg5 :float)
  (arg6 :float)
  (arg7 :float)
  (arg8 :float)
  (line_thickness :float)
  (arg10 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_stroke_rect" #.(swig-lispify "stroke_rect" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname)))
  (rounding :float)
  (line_thickness :float)
  (arg4 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_stroke_circle" #.(swig-lispify "stroke_circle" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname)))
  (line_thickness :float)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_stroke_arc" #.(swig-lispify "stroke_arc" 'function)) :void
  (arg0 :pointer)
  (cx :float)
  (cy :float)
  (radius :float)
  (a_min :float)
  (a_max :float)
  (line_thickness :float)
  (arg7 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_stroke_triangle" #.(swig-lispify "stroke_triangle" 'function)) :void
  (arg0 :pointer)
  (arg1 :float)
  (arg2 :float)
  (arg3 :float)
  (arg4 :float)
  (arg5 :float)
  (arg6 :float)
  (line_thichness :float)
  (arg8 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_stroke_polyline" #.(swig-lispify "stroke_polyline" 'function)) :void
  (arg0 :pointer)
  (points :pointer)
  (point_count :int)
  (line_thickness :float)
  (col (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_stroke_polygon" #.(swig-lispify "stroke_polygon" 'function)) :void
  (arg0 :pointer)
  (arg1 :pointer)
  (point_count :int)
  (line_thickness :float)
  (arg4 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_fill_rect" #.(swig-lispify "fill_rect" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname)))
  (rounding :float)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_fill_rect_multi_color" #.(swig-lispify "fill_rect_multi_color" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname)))
  (left (:struct #.(swig-lispify "color" 'classname)))
  (top (:struct #.(swig-lispify "color" 'classname)))
  (right (:struct #.(swig-lispify "color" 'classname)))
  (bottom (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_fill_circle" #.(swig-lispify "fill_circle" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname)))
  (arg2 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_fill_arc" #.(swig-lispify "fill_arc" 'function)) :void
  (arg0 :pointer)
  (cx :float)
  (cy :float)
  (radius :float)
  (a_min :float)
  (a_max :float)
  (arg6 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_fill_triangle" #.(swig-lispify "fill_triangle" 'function)) :void
  (arg0 :pointer)
  (x0 :float)
  (y0 :float)
  (x1 :float)
  (y1 :float)
  (x2 :float)
  (y2 :float)
  (arg7 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_fill_polygon" #.(swig-lispify "fill_polygon" 'function)) :void
  (arg0 :pointer)
  (arg1 :pointer)
  (point_count :int)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_draw_image" #.(swig-lispify "draw_image" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname)))
  (arg2 :pointer)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_draw_nine_slice" #.(swig-lispify "draw_nine_slice" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname)))
  (arg2 :pointer)
  (arg3 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_draw_text" #.(swig-lispify "draw_text" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname)))
  (text :string)
  (len :int)
  (arg4 :pointer)
  (arg5 (:struct #.(swig-lispify "color" 'classname)))
  (arg6 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_push_scissor" #.(swig-lispify "push_scissor" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_push_custom" #.(swig-lispify "push_custom" 'function)) :void
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname)))
  (arg2 :pointer)
  (usr :pointer))

(cffi:defcfun ("nk_input_has_mouse_click" #.(swig-lispify "input_has_mouse_click" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname)))

(cffi:defcfun ("nk_input_has_mouse_click_in_rect" #.(swig-lispify "input_has_mouse_click_in_rect" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname))
  (arg2 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_input_has_mouse_click_in_button_rect" #.(swig-lispify "input_has_mouse_click_in_button_rect" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname))
  (arg2 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_input_has_mouse_click_down_in_rect" #.(swig-lispify "input_has_mouse_click_down_in_rect" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname))
  (arg2 (:struct #.(swig-lispify "rect" 'classname)))
  (down :int))

(cffi:defcfun ("nk_input_is_mouse_click_in_rect" #.(swig-lispify "input_is_mouse_click_in_rect" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname))
  (arg2 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_input_is_mouse_click_down_in_rect" #.(swig-lispify "input_is_mouse_click_down_in_rect" 'function)) :int
  (i :pointer)
  (id #.(swig-lispify "buttons" 'enumname))
  (b (:struct #.(swig-lispify "rect" 'classname)))
  (down :int))

(cffi:defcfun ("nk_input_any_mouse_click_in_rect" #.(swig-lispify "input_any_mouse_click_in_rect" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_input_is_mouse_prev_hovering_rect" #.(swig-lispify "input_is_mouse_prev_hovering_rect" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_input_is_mouse_hovering_rect" #.(swig-lispify "input_is_mouse_hovering_rect" 'function)) :int
  (arg0 :pointer)
  (arg1 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_input_mouse_clicked" #.(swig-lispify "input_mouse_clicked" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname))
  (arg2 (:struct #.(swig-lispify "rect" 'classname))))

(cffi:defcfun ("nk_input_is_mouse_down" #.(swig-lispify "input_is_mouse_down" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname)))

(cffi:defcfun ("nk_input_is_mouse_pressed" #.(swig-lispify "input_is_mouse_pressed" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname)))

(cffi:defcfun ("nk_input_is_mouse_released" #.(swig-lispify "input_is_mouse_released" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "buttons" 'enumname)))

(cffi:defcfun ("nk_input_is_key_pressed" #.(swig-lispify "input_is_key_pressed" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "keys" 'enumname)))

(cffi:defcfun ("nk_input_is_key_released" #.(swig-lispify "input_is_key_released" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "keys" 'enumname)))

(cffi:defcfun ("nk_input_is_key_down" #.(swig-lispify "input_is_key_down" 'function)) :int
  (arg0 :pointer)
  (arg1 #.(swig-lispify "keys" 'enumname)))

(cffi:defcfun ("nk_style_item_color" #.(swig-lispify "style_item_color" 'function)) (:struct #.(swig-lispify "style_item" 'classname))
  (arg0 (:struct #.(swig-lispify "color" 'classname))))

(cffi:defcfun ("nk_style_item_image" #.(swig-lispify "style_item_image" 'function)) (:struct #.(swig-lispify "style_item" 'classname))
  (img (:struct #.(swig-lispify "image" 'classname))))

(cffi:defcfun ("nk_style_item_nine_slice" #.(swig-lispify "style_item_nine_slice" 'function)) (:struct #.(swig-lispify "style_item" 'classname))
  (slice (:struct #.(swig-lispify "nine_slice" 'classname))))

(cffi:defcfun ("nk_style_item_hide" #.(swig-lispify "style_item_hide" 'function)) (:struct #.(swig-lispify "style_item" 'classname)))

(cffi:defcfun ("nk_allegro5_init" #.(swig-lispify "allegro_init" 'function)) :pointer
  (font :pointer)
  (dsp :pointer)
  (width :unsigned-int)
  (height :unsigned-int))

(cffi:defcfun ("nk_allegro5_handle_event" #.(swig-lispify "allegro_handle_event" 'function)) :int
  (ev :pointer))

(cffi:defcfun ("nk_allegro5_shutdown" #.(swig-lispify "allegro_shutdown" 'function)) :void)

(cffi:defcfun ("nk_allegro5_render" #.(swig-lispify "allegro_render" 'function)) :void)

(cffi:defcfun ("nk_allegro5_create_image" #.(swig-lispify "allegro_create_image" 'function)) :pointer
  (file_name :string))

(cffi:defcfun ("nk_allegro5_del_image" #.(swig-lispify "allegro_del_image" 'function)) :void
  (image :pointer))

(cffi:defcfun ("nk_allegro5_font_create_from_file" #.(swig-lispify "allegro_font_create_from_file" 'function)) :pointer
  (file_name :string)
  (font_size :int)
  (flags :int))

(cffi:defcfun ("nk_allegro5_font_del" #.(swig-lispify "allegro_font_del" 'function)) :void
  (font :pointer))

(cffi:defcfun ("nk_allegro5_font_set_font" #.(swig-lispify "allegro_font_set_font" 'function)) :void
  (font :pointer))

(cffi:defcfun ("nk_allegro5_setup_assert" #.(swig-lispify "allegro_setup_assert" 'function)) :void
  (debug_break_callback :pointer)
  (abort_callback :pointer))


;; NOTE: redefinition
(cffi:defcstruct (image :class image)
  (handle :pointer)
  (w :unsigned-short)
  (h :unsigned-short)
  (region1 :unsigned-short)
  (region2 :unsigned-short)
  (region3 :unsigned-short)
  (region4 :unsigned-short))

(defmethod cffi:translate-into-foreign-memory (object (type image) pointer)
  (if (cffi:pointerp object) ;; allow passing result of nk:allegro-create-image as image struct
      (let (handle* w* h* region1* region2* region3* region4*)
        (cffi:with-foreign-slots ((handle w h region1 region2 region3 region4) object (:struct image))
          (setf handle* handle
                w* w
                h* h
                region1* region1
                region2* region2
                region3* region3
                region4* region4))
        (cffi:with-foreign-slots ((handle w h region1 region2 region3 region4) pointer (:struct image))
          (setf handle handle*
                w w*
                h h*
                region1 region1*
                region2 region2*
                region3 region3*
                region4 region4*)))
      (call-next-method)))

(cffi:defcfun ("nk_image" image) :void
  (arg0 :pointer)
  (arg1 (:struct image)))

(cffi:defcallback break-callback :void ((s :string))
    (break s))

(cffi:defcallback abort-callback :void ()
    (abort))

(allegro-setup-assert
    (cffi:callback break-callback)
    (cffi:callback abort-callback))



