#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>

#define NK_INCLUDE_DEFAULT_ALLOCATOR
#define NK_INCLUDE_FIXED_TYPES
#define NK_INCLUDE_STANDARD_IO
#define NK_BUTTON_TRIGGER_ON_RELEASE
#include "nuklear.h"


static char buffer[4096];

void print_kebabized(const char* title, const char* format, ...)
{
    char* c;
    va_list args;
    va_start(args, format);
    vsprintf(buffer, format, args);
    fprintf(stderr, "Generating %s...\n", title);
    for(c = buffer; *c; c++)
    {
        if(*c == '_')
            putchar('-');
        else
            putchar(*c);
    }
    va_end(args);
}

#define DEFOFFSET(field1, struct2, field2, struct3, field3)             \
    print_kebabized(#field1 "_" #field2 "_" #field3,                    \
                    "(defconstant +%s-%s-%s+ %d)\n",                    \
                    #field1, #field2, #field3,                          \
                    (int)(offsetof(struct nk_context, field1)           \
                          + offsetof(struct struct2, field2)            \
                          + offsetof(struct struct3, field3)))

#define DEFOFFSET4(field1, struct2, field2, struct3, field3, struct4, field4) \
    print_kebabized(#field1 "_" #field2 "_" #field3 "_" #field4,        \
                    "(defconstant +%s-%s-%s-%s+ %d)\n",                 \
                    #field1, #field2, #field3, #field4,                 \
                    (int)(offsetof(struct nk_context, field1)           \
                          + offsetof(struct struct2, field2)            \
                          + offsetof(struct struct3, field3)            \
                          + offsetof(struct struct4, field4)))

#define DEFOFFSET5(field1, struct2, field2, struct3, field3, struct4, field4, struct5, field5) \
    print_kebabized(#field1 "_" #field2 "_" #field3 "_" #field4 "_" #field5, \
                    "(defconstant +%s-%s-%s-%s-%s+ %d)\n",              \
                    #field1, #field2, #field3, #field4, #field5,        \
                    (int)(offsetof(struct nk_context, field1)           \
                          + offsetof(struct struct2, field2)            \
                          + offsetof(struct struct3, field3)            \
                          + offsetof(struct struct4, field4)            \
                          + offsetof(struct struct5, field5)))

#define DEFOFFSET6(field1, struct2, field2, struct3, field3,            \
                   struct4, field4, struct5, field5, struct6, field6)   \
    print_kebabized(#field1 "_" #field2 "_" #field3 "_" #field4 "_" #field5 "_" #field6, \
                    "(defconstant +%s-%s-%s-%s-%s-%s+ %d)\n",           \
                    #field1, #field2, #field3, #field4, #field5, #field6, \
                    (int)(offsetof(struct nk_context, field1)           \
                          + offsetof(struct struct2, field2)            \
                          + offsetof(struct struct3, field3)            \
                          + offsetof(struct struct4, field4)            \
                          + offsetof(struct struct5, field5)            \
                          + offsetof(struct struct6, field6)))

int main(void)
{
    fprintf(stderr, "Generating offsets...\n");
    printf(";; THIS FILE IS AUTOGENERATED, DO NOT EDIT\n");
    printf("(in-package :cl-liballegro-nuklear)\n");
    fprintf(stderr, "Wrote header\n");

    DEFOFFSET(style, nk_style, text, nk_style_text, color);
    DEFOFFSET(style, nk_style, text, nk_style_text, padding);

    DEFOFFSET(style, nk_style, button, nk_style_button, normal);
    DEFOFFSET(style, nk_style, button, nk_style_button, hover);
    DEFOFFSET(style, nk_style, button, nk_style_button, active);
    DEFOFFSET(style, nk_style, button, nk_style_button, border_color);
    DEFOFFSET(style, nk_style, button, nk_style_button, text_background);
    DEFOFFSET(style, nk_style, button, nk_style_button, text_normal);
    DEFOFFSET(style, nk_style, button, nk_style_button, text_hover);
    DEFOFFSET(style, nk_style, button, nk_style_button, text_active);
    DEFOFFSET(style, nk_style, button, nk_style_button, text_alignment);
    DEFOFFSET(style, nk_style, button, nk_style_button, border);
    DEFOFFSET(style, nk_style, button, nk_style_button, rounding);
    DEFOFFSET(style, nk_style, button, nk_style_button, padding);
    DEFOFFSET(style, nk_style, button, nk_style_button, image_padding);
    DEFOFFSET(style, nk_style, button, nk_style_button, touch_padding);

    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, normal);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, hover);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, active);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, border_color);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, text_background);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, text_normal);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, text_hover);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, text_active);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, text_alignment);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, border);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, rounding);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, padding);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, image_padding);
    DEFOFFSET(style, nk_style, contextual_button, nk_style_button, touch_padding);

    DEFOFFSET(style, nk_style, menu_button, nk_style_button, normal);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, hover);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, active);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, border_color);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, text_background);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, text_normal);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, text_hover);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, text_active);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, text_alignment);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, border);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, rounding);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, padding);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, image_padding);
    DEFOFFSET(style, nk_style, menu_button, nk_style_button, touch_padding);

    DEFOFFSET(style, nk_style, option, nk_style_toggle, normal);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, hover);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, active);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, border_color);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, cursor_normal);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, cursor_hover);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, text_normal);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, text_hover);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, text_active);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, text_background);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, text_alignment);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, padding);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, touch_padding);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, spacing);
    DEFOFFSET(style, nk_style, option, nk_style_toggle, border);

    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, normal);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, hover);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, active);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, border_color);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, cursor_normal);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, cursor_hover);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, text_normal);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, text_hover);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, text_active);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, text_background);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, text_alignment);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, padding);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, touch_padding);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, spacing);
    DEFOFFSET(style, nk_style, checkbox, nk_style_toggle, border);

    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, normal);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, hover);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, pressed);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, normal_active);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, hover_active);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, pressed_active);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, text_normal);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, text_hover);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, text_pressed);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, text_normal_active);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, text_hover_active);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, text_pressed_active);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, text_background);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, text_alignment);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, rounding);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, padding);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, touch_padding);
    DEFOFFSET(style, nk_style, selectable, nk_style_selectable, image_padding);

    DEFOFFSET(style, nk_style, slider, nk_style_slider, normal);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, hover);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, active);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, border_color);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, bar_normal);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, bar_hover);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, bar_active);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, bar_filled);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, cursor_normal);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, cursor_hover);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, cursor_active);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, border);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, rounding);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, bar_height);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, padding);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, spacing);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, cursor_size);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, show_buttons);

    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, inc_button, nk_style_button, touch_padding);

    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, slider, nk_style_slider, dec_button, nk_style_button, touch_padding);

    DEFOFFSET(style, nk_style, slider, nk_style_slider, inc_symbol);
    DEFOFFSET(style, nk_style, slider, nk_style_slider, dec_symbol);

    DEFOFFSET(style, nk_style, knob, nk_style_knob, normal);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, hover);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, active);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, border_color);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, knob_normal);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, knob_hover);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, knob_active);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, knob_border_color);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, cursor_normal);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, cursor_hover);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, cursor_active);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, border);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, knob_border);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, padding);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, spacing);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, cursor_width);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, color_factor);
    DEFOFFSET(style, nk_style, knob, nk_style_knob, disabled_factor);

    DEFOFFSET(style, nk_style, progress, nk_style_progress, normal);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, hover);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, active);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, border_color);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, cursor_normal);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, cursor_hover);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, cursor_active);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, cursor_border_color);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, rounding);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, border);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, cursor_border);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, cursor_rounding);
    DEFOFFSET(style, nk_style, progress, nk_style_progress, padding);

    DEFOFFSET(style, nk_style, property, nk_style_property, normal);
    DEFOFFSET(style, nk_style, property, nk_style_property, hover);
    DEFOFFSET(style, nk_style, property, nk_style_property, active);
    DEFOFFSET(style, nk_style, property, nk_style_property, border_color);
    DEFOFFSET(style, nk_style, property, nk_style_property, label_normal);
    DEFOFFSET(style, nk_style, property, nk_style_property, label_hover);
    DEFOFFSET(style, nk_style, property, nk_style_property, label_active);
    DEFOFFSET(style, nk_style, property, nk_style_property, sym_left);
    DEFOFFSET(style, nk_style, property, nk_style_property, sym_right);
    DEFOFFSET(style, nk_style, property, nk_style_property, border);
    DEFOFFSET(style, nk_style, property, nk_style_property, rounding);
    DEFOFFSET(style, nk_style, property, nk_style_property, padding);

    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, active);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, border_color);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, border_color);

    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, normal);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, hover);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, active);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, border_color);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, cursor_normal);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, cursor_hover);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, cursor_active);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, cursor_border_color);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, border);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, rounding);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, border_cursor);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, padding);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, show_buttons);

    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, normal);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, hover);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, active);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, border_color);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_background);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_normal);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_hover);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_active);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_alignment);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, border);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, rounding);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, padding);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, image_padding);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, touch_padding);

    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, normal);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, hover);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, active);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, border_color);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_background);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_normal);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_hover);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_active);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_alignment);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, border);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, rounding);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, padding);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, image_padding);
    DEFOFFSET6(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, touch_padding);

    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_symbol);
    DEFOFFSET5(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_symbol);

    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, cursor_normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, cursor_hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, cursor_text_normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, cursor_text_hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, text_normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, text_hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, text_active);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, selected_normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, selected_hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, selected_text_normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, selected_text_hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, border);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, rounding);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, cursor_size);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, scrollbar_size);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, padding);
    DEFOFFSET4(style, nk_style, property, nk_style_property, edit, nk_style_edit, row_padding);

    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, property, nk_style_property, inc_button, nk_style_button, touch_padding);

    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, property, nk_style_property, dec_button, nk_style_button, touch_padding);

    DEFOFFSET(style, nk_style, edit, nk_style_edit, normal);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, hover);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, active);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, border_color);

    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, normal);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, hover);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, active);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, border_color);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, cursor_normal);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, cursor_hover);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, cursor_active);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, cursor_border_color);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, border);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, rounding);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, border_cursor);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, padding);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, show_buttons);

    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, normal);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, hover);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, active);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, border_color);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_background);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_normal);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_hover);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_active);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, text_alignment);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, border);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, rounding);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, padding);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, image_padding);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_button, nk_style_button, touch_padding);

    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, normal);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, hover);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, active);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, border_color);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_background);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_normal);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_hover);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_active);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, text_alignment);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, border);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, rounding);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, padding);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, image_padding);
    DEFOFFSET5(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_button, nk_style_button, touch_padding);

    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, inc_symbol);
    DEFOFFSET4(style, nk_style, edit, nk_style_edit, scrollbar, nk_style_scrollbar, dec_symbol);

    DEFOFFSET(style, nk_style, edit, nk_style_edit, cursor_normal);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, cursor_hover);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, cursor_text_normal);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, cursor_text_hover);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, text_normal);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, text_hover);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, text_active);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, selected_normal);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, selected_hover);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, selected_text_normal);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, selected_text_hover);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, border);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, rounding);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, cursor_size);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, scrollbar_size);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, padding);
    DEFOFFSET(style, nk_style, edit, nk_style_edit, row_padding);

    DEFOFFSET(style, nk_style, chart, nk_style_chart, background);
    DEFOFFSET(style, nk_style, chart, nk_style_chart, border_color);
    DEFOFFSET(style, nk_style, chart, nk_style_chart, selected_color);
    DEFOFFSET(style, nk_style, chart, nk_style_chart, color);
    DEFOFFSET(style, nk_style, chart, nk_style_chart, border);
    DEFOFFSET(style, nk_style, chart, nk_style_chart, rounding);
    DEFOFFSET(style, nk_style, chart, nk_style_chart, padding);

    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, normal);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, hover);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, active);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, border_color);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, cursor_normal);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, cursor_hover);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, cursor_active);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, cursor_border_color);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, border);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, rounding);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, border_cursor);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, padding);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, show_buttons);

    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, inc_button, nk_style_button, touch_padding);

    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, scrollh, nk_style_scrollbar, dec_button, nk_style_button, touch_padding);

    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, inc_symbol);
    DEFOFFSET(style, nk_style, scrollh, nk_style_scrollbar, dec_symbol);

    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, normal);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, hover);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, active);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, border_color);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, cursor_normal);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, cursor_hover);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, cursor_active);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, cursor_border_color);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, border);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, rounding);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, border_cursor);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, padding);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, show_buttons);

    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, inc_button, nk_style_button, touch_padding);

    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, scrollv, nk_style_scrollbar, dec_button, nk_style_button, touch_padding);

    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, inc_symbol);
    DEFOFFSET(style, nk_style, scrollv, nk_style_scrollbar, dec_symbol);

    DEFOFFSET(style, nk_style, tab, nk_style_tab, background);
    DEFOFFSET(style, nk_style, tab, nk_style_tab, border_color);
    DEFOFFSET(style, nk_style, tab, nk_style_tab, text);

    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_maximize_button, nk_style_button, touch_padding);

    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, tab_minimize_button, nk_style_button, touch_padding);

    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_maximize_button, nk_style_button, touch_padding);

    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, tab, nk_style_tab, node_minimize_button, nk_style_button, touch_padding);

    DEFOFFSET(style, nk_style, tab, nk_style_tab, sym_minimize);
    DEFOFFSET(style, nk_style, tab, nk_style_tab, sym_maximize);
    DEFOFFSET(style, nk_style, tab, nk_style_tab, border);
    DEFOFFSET(style, nk_style, tab, nk_style_tab, rounding);
    DEFOFFSET(style, nk_style, tab, nk_style_tab, indent);
    DEFOFFSET(style, nk_style, tab, nk_style_tab, padding);
    DEFOFFSET(style, nk_style, tab, nk_style_tab, spacing);

    DEFOFFSET(style, nk_style, combo, nk_style_combo, normal);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, hover);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, active);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, border_color);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, label_normal);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, label_hover);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, label_active);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, symbol_normal);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, symbol_hover);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, symbol_active);

    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, normal);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, hover);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, active);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, border_color);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, text_background);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, text_normal);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, text_hover);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, text_active);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, text_alignment);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, border);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, rounding);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, padding);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, image_padding);
    DEFOFFSET4(style, nk_style, combo, nk_style_combo, button, nk_style_button, touch_padding);

    DEFOFFSET(style, nk_style, combo, nk_style_combo, sym_normal);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, sym_hover);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, sym_active);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, border);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, rounding);
    DEFOFFSET(style, nk_style, combo, nk_style_combo, content_padding);
    /*DEFOFFSET(style, nk_style, combo, nk_style_combo, button_padding);*/
    DEFOFFSET(style, nk_style, combo, nk_style_combo, spacing);

    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, normal);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, hover);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, active);

    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, normal);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, hover);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, active);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, border_color);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, text_background);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, text_normal);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, text_hover);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, text_active);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, text_alignment);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, border);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, rounding);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, padding);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, image_padding);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_button, nk_style_button, touch_padding);

    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, normal);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, hover);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, active);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, border_color);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, text_background);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, text_normal);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, text_hover);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, text_active);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, text_alignment);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, border);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, rounding);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, padding);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, image_padding);
    DEFOFFSET5(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_button, nk_style_button, touch_padding);

    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, close_symbol);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, minimize_symbol);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, maximize_symbol);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, label_normal);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, label_hover);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, label_active);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, align);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, padding);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, label_padding);
    DEFOFFSET4(style, nk_style, window, nk_style_window, header, nk_style_window_header, spacing);

    DEFOFFSET(style, nk_style, window, nk_style_window, fixed_background);
    DEFOFFSET(style, nk_style, window, nk_style_window, background);
    DEFOFFSET(style, nk_style, window, nk_style_window, border_color);
    DEFOFFSET(style, nk_style, window, nk_style_window, popup_border_color);
    DEFOFFSET(style, nk_style, window, nk_style_window, combo_border_color);
    DEFOFFSET(style, nk_style, window, nk_style_window, contextual_border_color);
    DEFOFFSET(style, nk_style, window, nk_style_window, menu_border_color);
    DEFOFFSET(style, nk_style, window, nk_style_window, group_border_color);
    DEFOFFSET(style, nk_style, window, nk_style_window, tooltip_border_color);
    DEFOFFSET(style, nk_style, window, nk_style_window, scaler);
    DEFOFFSET(style, nk_style, window, nk_style_window, border);
    DEFOFFSET(style, nk_style, window, nk_style_window, combo_border);
    DEFOFFSET(style, nk_style, window, nk_style_window, contextual_border);
    DEFOFFSET(style, nk_style, window, nk_style_window, menu_border);
    DEFOFFSET(style, nk_style, window, nk_style_window, group_border);
    DEFOFFSET(style, nk_style, window, nk_style_window, tooltip_border);
    DEFOFFSET(style, nk_style, window, nk_style_window, popup_border);
    DEFOFFSET(style, nk_style, window, nk_style_window, min_row_height_padding);
    DEFOFFSET(style, nk_style, window, nk_style_window, rounding);
    DEFOFFSET(style, nk_style, window, nk_style_window, spacing);
    DEFOFFSET(style, nk_style, window, nk_style_window, scrollbar_size);
    DEFOFFSET(style, nk_style, window, nk_style_window, padding);
    DEFOFFSET(style, nk_style, window, nk_style_window, group_padding);
    DEFOFFSET(style, nk_style, window, nk_style_window, popup_padding);
    DEFOFFSET(style, nk_style, window, nk_style_window, combo_padding);
    DEFOFFSET(style, nk_style, window, nk_style_window, contextual_padding);
    DEFOFFSET(style, nk_style, window, nk_style_window, menu_padding);
    DEFOFFSET(style, nk_style, window, nk_style_window, tooltip_padding);

    fprintf(stderr, "Done.\n");
    return EXIT_SUCCESS;
}
