(in-package #:cl-liballegro)

(defcfun ("al_fopen" fopen) :pointer (path :string) (mode :string))
(defcfun ("al_fopen_interface" fopen-interface) :pointer (drv :pointer) (path :string) (mode :string))
(defcfun ("al_fopen_slice" fopen-slice) :pointer (file :pointer) (size :uint) (mode :string))
(defcfun ("al_fclose" fclose) :void (file :pointer))
(defcfun ("al_fread" fread) :uint (file :pointer) (ptr :pointer) (size :uint))
(defcfun ("al_fwrite" fwrite) :uint (file :pointer) (ptr :pointer) (size :uint))
(defcfun ("al_fflush" fflush) :boolean (file :pointer))
(defcfun ("al_ftell" ftell) :uint64 (file :pointer))
(defcfun ("al_fseek" fseek) :boolean (file :pointer) (offset :uint64) (whence seek))
(defcfun ("al_feof" feof) :boolean (file :pointer))
(defcfun ("al_ferror" ferror) :boolean (file :pointer))
(defcfun ("al_ferrmsg" ferrmsg) :string (file :pointer))
(defcfun ("al_fclearerr" fclearerr) :void (file :pointer))
(defcfun ("al_fungetc" fungetc) :int (file :pointer) (c :int))
(defcfun ("al_fsize" fsize) :uint64 (file :pointer)) 
(defcfun ("al_fgetc" fgetc) :int (file :pointer))
(defcfun ("al_fputc" fputc) :int (file :pointer) (c :int))
(defcfun ("al_fread16le" fread16le) :uint16 (file :pointer)) 
(defcfun ("al_fread16be" fread16be) :uint16 (file :pointer)) 
(defcfun ("al_fwrite16le" fwrite16le) :uint (file :pointer) (w :uint16)) 
(defcfun ("al_fwrite16be" fwrite16be) :uint (file :pointer) (w :uint16)) 
(defcfun ("al_fread32le" fread32le) :uint32 (file :pointer)) 
(defcfun ("al_fread32be" fread32be) :uint32 (file :pointer)) 
(defcfun ("al_fwrite32le" fwrite32le) :uint (file :pointer) (l :uint32)) 
(defcfun ("al_fwrite32be" fwrite32be) :uint (file :pointer) (l :uint32)) 
(defcfun ("al_fgets" fgets) :pointer (file :pointer) (buf :pointer) (max :uint))
(defcfun ("al_fget_ustr" fget_ustr) :pointer (file :pointer))
(defcfun ("al_fputs" fputs) :int (file :pointer) (str :string))

;; Standard I/O specific routines
(defcfun ("al_fopen_fd" fopen-fd) :pointer (fd c-int) (mode :string))
(defcfun ("al_make_temp_file" make-temp-file) :pointer (template :string) (ret-path :pointer))

;; Alternative file streams
(defcfun ("al_set_new_file_interface" set-new-file-interface) :void (file-interface :pointer))
(defcfun ("al_set_standard_file_interface" set-standard-file-interface) :void)
(defcfun ("al_get_new_file_interface" get-new-file-interface) :pointer)
(defcfun ("al_create_file_handle" create-file-handle) :pointer (drv :pointer) (userdarat :pointer))
(defcfun ("al_get_file_userdata" get-file-userdata) :pointer (file :pointer))
